/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.AttributeModuleBuilder;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record AttributeModule(String unique, Attribute attribute, AttributeModifier.Operation operation, LevelingValue amount, UUID[] slotUUIDs, ModifierModuleCondition condition) implements AttributesModifierHook,
ModifierModule,
ModifierModuleCondition.ConditionalModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.ATTRIBUTES);
    public static final RecordLoadable<AttributeModule> LOADER = RecordLoadable.create((RecordField)StringLoadable.DEFAULT.requiredField("unique", AttributeModule::unique), (RecordField)Loadables.ATTRIBUTE.requiredField("attribute", AttributeModule::attribute), (RecordField)TinkerLoadables.OPERATION.requiredField("operation", AttributeModule::operation), (RecordField)LevelingValue.LOADABLE.directField(AttributeModule::amount), (RecordField)TinkerLoadables.EQUIPMENT_SLOT_SET.requiredField("slots", m -> AttributeModule.uuidsToSlots(m.slotUUIDs)), ModifierModuleCondition.FIELD, (unique, attribute, operation, amount, slots, condition) -> new AttributeModule((String)unique, (Attribute)attribute, (AttributeModifier.Operation)operation, (LevelingValue)amount, AttributeModule.slotsToUUIDs(unique, slots), (ModifierModuleCondition)condition));

    public static UUID getUUID(String name, EquipmentSlot slot) {
        return UUID.nameUUIDFromBytes((name + "." + slot.m_20751_()).getBytes());
    }

    public static UUID[] slotsToUUIDs(String name, Collection<EquipmentSlot> slots) {
        UUID[] slotUUIDs = new UUID[6];
        for (EquipmentSlot slot : slots) {
            slotUUIDs[slot.m_20750_()] = AttributeModule.getUUID(name, slot);
        }
        return slotUUIDs;
    }

    public static Set<EquipmentSlot> uuidsToSlots(UUID[] uuids) {
        EnumSet<EquipmentSlot> set = EnumSet.noneOf(EquipmentSlot.class);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (uuids[slot.m_20750_()] == null) continue;
            set.add(slot);
        }
        return set;
    }

    @Override
    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        UUID uuid;
        if (this.condition.matches(tool, modifier) && (uuid = this.slotUUIDs[slot.m_20750_()]) != null) {
            consumer.accept(this.attribute, new AttributeModifier(uuid, this.unique + "." + slot.m_20751_(), (double)this.amount.compute(modifier.getEffectiveLevel()), this.operation));
        }
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder builder(Attribute attribute, AttributeModifier.Operation operation) {
        return new Builder(attribute, operation);
    }

    public static class Builder
    extends AttributeModuleBuilder<Builder, AttributeModule> {
        private EquipmentSlot[] slots = EquipmentSlot.values();

        protected Builder(Attribute attribute, AttributeModifier.Operation operation) {
            super(attribute, operation);
        }

        public Builder slots(EquipmentSlot ... slots) {
            this.slots = slots;
            return this;
        }

        @Override
        public AttributeModule amount(float flat, float eachLevel) {
            if (this.unique == null) {
                throw new IllegalStateException("Must set unique for attributes");
            }
            return new AttributeModule(this.unique, this.attribute, this.operation, new LevelingValue(flat, eachLevel), AttributeModule.slotsToUUIDs(this.unique, List.of(this.slots)), this.condition);
        }
    }
}

