/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.armor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.util.LazyOptional;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public record ProtectionModule(IJsonPredicate<DamageSource> source, IJsonPredicate<LivingEntity> entity, LevelingValue amount, @Nullable Enchantment subtract, ModifierModuleCondition condition) implements ProtectionModifierHook,
TooltipModifierHook,
ModifierModule,
ModifierModuleCondition.ConditionalModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.PROTECTION, TinkerHooks.TOOLTIP);
    public static final RecordLoadable<ProtectionModule> LOADER = RecordLoadable.create((RecordField)DamageSourcePredicate.LOADER.defaultField("damage_source", ProtectionModule::source), (RecordField)LivingEntityPredicate.LOADER.defaultField("wearing_entity", ProtectionModule::entity), (RecordField)LevelingValue.LOADABLE.directField(ProtectionModule::amount), (RecordField)Loadables.ENCHANTMENT.nullableField("subtract_enchantment", ProtectionModule::subtract), ModifierModuleCondition.FIELD, ProtectionModule::new);

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        if (this.condition.matches(tool, modifier) && this.source.matches((Object)source) && this.entity.matches((Object)context.getEntity())) {
            if (this.subtract != null && LogicHelper.isInList((Object[])this.subtract.f_44671_, (Object)slotType)) {
                float scaledLevel = modifier.getEffectiveLevel();
                modifierValue += this.amount.compute(scaledLevel) - (float)this.subtract.m_7205_(Mth.m_14143_((float)scaledLevel), source);
            } else {
                modifierValue += this.amount.compute(modifier.getEffectiveLevel());
            }
        }
        return modifierValue;
    }

    public static void addResistanceTooltip(IToolStackView tool, Modifier modifier, float amount, @Nullable Player player, List<Component> tooltip) {
        float cap = player != null ? ProtectionModifierHook.getProtectionCap((LazyOptional<TinkerDataCapability.Holder>)player.getCapability(TinkerDataCapability.CAPABILITY)) : Math.min(20.0f + (float)tool.getModifierLevel(TinkerModifiers.boundless.getId()) * 2.5f, 19.0f);
        tooltip.add((Component)modifier.applyStyle(Component.m_237113_((String)Util.PERCENT_BOOST_FORMAT.format(Math.min(amount, cap) / 25.0f)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)(modifier.getTranslationKey() + ".resistance")))));
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (this.condition.matches(tool, modifier)) {
            ProtectionModule.addResistanceTooltip(tool, modifier.getModifier(), this.amount.compute(modifier.getEffectiveLevel()), player, tooltip);
        }
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder source(IJsonPredicate<DamageSource> source) {
        return new Builder(source);
    }

    public static class Builder
    extends ModifierModuleCondition.Builder<Builder>
    implements LevelingValue.Builder<ProtectionModule> {
        private final IJsonPredicate<DamageSource> source;
        private IJsonPredicate<LivingEntity> entity = LivingEntityPredicate.ANY;
        private Enchantment subtract;

        @Override
        public ProtectionModule amount(float flat, float eachLevel) {
            return new ProtectionModule(this.source, this.entity, new LevelingValue(flat, eachLevel), this.subtract, this.condition);
        }

        public Builder entity(IJsonPredicate<LivingEntity> entity) {
            this.entity = entity;
            return this;
        }

        public Builder subtract(Enchantment subtract) {
            this.subtract = subtract;
            return this;
        }

        private Builder(IJsonPredicate<DamageSource> source) {
            this.source = source;
        }
    }
}

