/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.modules.ModifierHookProvider;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;

public interface ModifierModule
extends GenericLoaderRegistry.IHaveLoader,
ModifierHookProvider {
    public static final GenericLoaderRegistry<ModifierModule> LOADER = new GenericLoaderRegistry("Modifier Module", false);

    @Nullable
    default public Integer getPriority() {
        return null;
    }

    public static ModifierHookMap createMap(List<ModuleWithHooks> modules) {
        ModifierHookMap.Builder builder = ModifierHookMap.builder();
        for (ModuleWithHooks module : modules) {
            for (ModifierHook<?> hook : module.getModuleHooks()) {
                builder.addHookChecked(module.module(), hook);
            }
        }
        return builder.build();
    }

    @SafeVarargs
    public static <T> List<ModifierHook<?>> defaultHooks(ModifierHook<? super T> ... hooks) {
        return List.of(hooks);
    }

    public record ModuleWithHooks(ModifierModule module, List<ModifierHook<?>> hooks) {
        public List<ModifierHook<?>> getModuleHooks() {
            if (this.hooks.isEmpty()) {
                return this.module.getDefaultHooks();
            }
            return this.hooks;
        }

        public JsonObject serialize() {
            JsonElement json = LOADER.serialize((GenericLoaderRegistry.IHaveLoader)this.module);
            if (!json.isJsonObject()) {
                throw new JsonSyntaxException("Serializers for modifier modules must return json objects");
            }
            JsonObject object = json.getAsJsonObject();
            if (!this.hooks.isEmpty()) {
                JsonArray hooks = new JsonArray();
                for (ModifierHook<?> hook : this.hooks) {
                    hooks.add(hook.getName().toString());
                }
                object.add("hooks", (JsonElement)hooks);
            }
            return object;
        }

        public static ModuleWithHooks deserialize(JsonObject json) {
            List hooks = Collections.emptyList();
            if (json.has("hooks")) {
                hooks = JsonHelper.parseList((JsonObject)json, (String)"hooks", (element, key) -> {
                    ResourceLocation name = JsonHelper.convertToResourceLocation((JsonElement)element, (String)key);
                    ModifierHook<?> hook = ModifierHooks.getHook(name);
                    if (hook == null) {
                        throw new JsonSyntaxException("Unknown modifier hook " + name);
                    }
                    return hook;
                });
            }
            ModifierModule module = (ModifierModule)LOADER.deserialize((JsonElement)json);
            return new ModuleWithHooks(module, hooks);
        }

        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.m_130130_(this.hooks.size());
            for (ModifierHook<?> hook : this.hooks) {
                buffer.m_130085_(hook.getName());
            }
            LOADER.encode(buffer, (GenericLoaderRegistry.IHaveLoader)this.module);
        }

        public static ModuleWithHooks fromNetwork(FriendlyByteBuf buffer) {
            int hookCount = buffer.m_130242_();
            ImmutableList.Builder hooks = ImmutableList.builder();
            for (int i = 0; i < hookCount; ++i) {
                ResourceLocation location = buffer.m_130281_();
                ModifierHook<?> hook = ModifierHooks.getHook(location);
                if (hook == null) {
                    throw new DecoderException("Unknown modifier hook " + location);
                }
                hooks.add(hook);
            }
            ModifierModule module = (ModifierModule)LOADER.decode(buffer);
            return new ModuleWithHooks(module, (List<ModifierHook<?>>)hooks.build());
        }
    }
}

