/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import net.minecraft.network.chat.Component;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.dynamic.ComposableModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;

public class BasicModifier
extends Modifier {
    protected final ModifierLevelDisplay levelDisplay;
    protected final ComposableModifier.TooltipDisplay tooltipDisplay;
    protected final int priority;

    public BasicModifier(ModifierHookMap hookMap, ModifierLevelDisplay levelDisplay, ComposableModifier.TooltipDisplay tooltipDisplay, int priority) {
        super(hookMap);
        this.levelDisplay = levelDisplay;
        this.tooltipDisplay = tooltipDisplay;
        this.priority = priority;
    }

    @Override
    protected final void registerHooks(ModifierHookMap.Builder hookBuilder) {
    }

    @Override
    public Component getDisplayName(int level) {
        return this.levelDisplay.nameForLevel(this, level);
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return advanced ? this.tooltipDisplay != ComposableModifier.TooltipDisplay.NEVER : this.tooltipDisplay == ComposableModifier.TooltipDisplay.ALWAYS;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public static class Builder {
        private final ModifierHookMap hookMap;
        private ModifierLevelDisplay levelDisplay = ModifierLevelDisplay.DEFAULT;
        private ComposableModifier.TooltipDisplay tooltipDisplay = ComposableModifier.TooltipDisplay.ALWAYS;
        private int priority = 100;

        public BasicModifier build() {
            return new BasicModifier(this.hookMap, this.levelDisplay, this.tooltipDisplay, this.priority);
        }

        public Builder levelDisplay(ModifierLevelDisplay levelDisplay) {
            this.levelDisplay = levelDisplay;
            return this;
        }

        public Builder tooltipDisplay(ComposableModifier.TooltipDisplay tooltipDisplay) {
            this.tooltipDisplay = tooltipDisplay;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        private Builder(ModifierHookMap hookMap) {
            this.hookMap = hookMap;
        }

        public static Builder builder(ModifierHookMap hookMap) {
            return new Builder(hookMap);
        }
    }
}

