/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.mining;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.EnchantmentModifierHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface HarvestEnchantmentsModifierHook {
    public static final EquipmentSlot[] APPLICABLE_SLOTS = new EquipmentSlot[]{EquipmentSlot.OFFHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final String TAG_ENCHANTMENTS = "Enchantments";

    public void updateHarvestEnchantments(IToolStackView var1, ModifierEntry var2, ToolHarvestContext var3, EquipmentContext var4, EquipmentSlot var5, Map<Enchantment, Integer> var6);

    @Nullable
    public static ListTag updateHarvestEnchantments(IToolStackView tool, ItemStack stack, ToolHarvestContext context) {
        ServerPlayer player = context.getPlayer();
        if (player == null || !player.m_7500_()) {
            EquipmentContext equipmentContext = EquipmentContext.withTool(context.getLiving(), tool, EquipmentSlot.MAINHAND);
            ListTag originalEnchants = null;
            Map enchantments = null;
            for (EquipmentSlot slot : APPLICABLE_SLOTS) {
                IToolStackView armor = equipmentContext.getValidTool(slot);
                if (armor == null) continue;
                for (ModifierEntry entry : armor.getModifierList()) {
                    HarvestEnchantmentsModifierHook hook = entry.getModifier().getHooks().getOrNull(TinkerHooks.HARVEST_ENCHANTMENTS);
                    if (hook == null) continue;
                    if (enchantments == null) {
                        originalEnchants = stack.m_41785_();
                        enchantments = EnchantmentHelper.m_44882_((ListTag)originalEnchants);
                    }
                    hook.updateHarvestEnchantments(armor, entry, context, equipmentContext, slot, enchantments);
                }
            }
            if (enchantments != null) {
                enchantments.values().removeIf(EnchantmentModifierHook.VALUE_REMOVER);
                EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)stack);
                return originalEnchants;
            }
        }
        return null;
    }

    public static void restoreEnchantments(ItemStack stack, ListTag originalTag) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            if (originalTag.isEmpty()) {
                nbt.m_128473_(TAG_ENCHANTMENTS);
            } else {
                nbt.m_128365_(TAG_ENCHANTMENTS, (Tag)originalTag);
            }
        }
    }

    public record AllMerger(Collection<HarvestEnchantmentsModifierHook> modules) implements HarvestEnchantmentsModifierHook
    {
        @Override
        public void updateHarvestEnchantments(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, EquipmentContext equipment, EquipmentSlot slot, Map<Enchantment, Integer> map) {
            for (HarvestEnchantmentsModifierHook module : this.modules) {
                module.updateHarvestEnchantments(tool, modifier, context, equipment, slot, map);
            }
        }
    }
}

