/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.interaction;

import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.UseAnim;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public interface GeneralInteractionModifierHook {
    public static final ResourceLocation KEY_ACTIVE_MODIFIER = TConstruct.getResource("active_modifier");
    public static final ResourceLocation KEY_DRAWTIME = TConstruct.getResource("drawtime");

    public InteractionResult onToolUse(IToolStackView var1, ModifierEntry var2, Player var3, InteractionHand var4, InteractionSource var5);

    default public void onUsingTick(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int timeLeft) {
    }

    default public void onStoppedUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int timeLeft) {
    }

    default public void onFinishUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
    }

    default public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 0;
    }

    default public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return UseAnim.NONE;
    }

    public static void startUsing(IToolStackView tool, ModifierId modifier, LivingEntity living, InteractionHand hand) {
        tool.getPersistentData().putString(KEY_ACTIVE_MODIFIER, modifier.toString());
        living.m_6672_(hand);
    }

    public static void startDrawtime(IToolStackView tool, LivingEntity living, float speedFactor) {
        tool.getPersistentData().putInt(KEY_DRAWTIME, (int)Math.ceil(20.0f * speedFactor / ConditionalStatModifierHook.getModifiedStat(tool, living, ToolStats.DRAW_SPEED)));
    }

    public static void startUsingWithDrawtime(IToolStackView tool, ModifierId modifier, LivingEntity living, InteractionHand hand, float speedFactor) {
        GeneralInteractionModifierHook.startDrawtime(tool, living, speedFactor);
        GeneralInteractionModifierHook.startUsing(tool, modifier, living, hand);
    }

    public static float getToolCharge(IToolStackView tool, float chargeTime) {
        float charge = chargeTime / (float)tool.getPersistentData().getInt(KEY_DRAWTIME);
        if ((charge = (charge * charge + charge * 2.0f) / 3.0f) > 1.0f) {
            charge = 1.0f;
        }
        return charge;
    }

    public static ModifierEntry getActiveModifier(IToolStackView tool) {
        ModifierId modifier;
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(KEY_ACTIVE_MODIFIER, 8) && (modifier = ModifierId.tryParse(persistentData.getString(KEY_ACTIVE_MODIFIER))) != null) {
            return tool.getModifiers().getEntry(modifier);
        }
        return ModifierEntry.EMPTY;
    }

    public static void finishUsing(IToolStackView tool) {
        ModDataNBT persistentData = tool.getPersistentData();
        persistentData.remove(KEY_ACTIVE_MODIFIER);
        persistentData.remove(KEY_DRAWTIME);
    }

    public record FirstMerger(Collection<GeneralInteractionModifierHook> modules) implements GeneralInteractionModifierHook
    {
        @Override
        public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
            InteractionResult result = InteractionResult.PASS;
            for (GeneralInteractionModifierHook module : this.modules) {
                result = module.onToolUse(tool, modifier, player, hand, source);
                if (!result.m_19077_()) continue;
                return result;
            }
            return result;
        }

        @Override
        public void onStoppedUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int timeLeft) {
            for (GeneralInteractionModifierHook module : this.modules) {
                module.onStoppedUsing(tool, modifier, entity, timeLeft);
            }
        }

        @Override
        public void onFinishUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
            for (GeneralInteractionModifierHook module : this.modules) {
                module.onFinishUsing(tool, modifier, entity);
            }
        }

        @Override
        public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
            for (GeneralInteractionModifierHook module : this.modules) {
                int duration = module.getUseDuration(tool, modifier);
                if (duration <= 0) continue;
                return duration;
            }
            return 0;
        }

        @Override
        public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
            for (GeneralInteractionModifierHook module : this.modules) {
                UseAnim anim = module.getUseAction(tool, modifier);
                if (anim == UseAnim.NONE) continue;
                return anim;
            }
            return UseAnim.NONE;
        }
    }
}

