/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.behavior;

import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockHarvestModifierHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public interface EnchantmentModifierHook {
    public static final Predicate<Integer> VALUE_REMOVER = value -> value == null || value <= 0;

    public int updateEnchantmentLevel(IToolStackView var1, ModifierEntry var2, Enchantment var3, int var4);

    public void updateEnchantments(IToolStackView var1, ModifierEntry var2, Map<Enchantment, Integer> var3);

    public static void addEnchantment(Map<Enchantment, Integer> map, Enchantment enchantment, int amount) {
        if (amount != 0) {
            map.put(enchantment, map.getOrDefault(enchantment, 0) + amount);
        }
    }

    public static int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)stack);
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            level = entry.getHook(TinkerHooks.ENCHANTMENTS).updateEnchantmentLevel(tool, entry, enchantment, level);
        }
        return Math.max(level, 0);
    }

    public static Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getHook(TinkerHooks.ENCHANTMENTS).updateEnchantments(tool, entry, enchantments);
        }
        enchantments.values().removeIf(VALUE_REMOVER);
        return enchantments;
    }

    public static interface SingleHarvestEnchantment
    extends SingleEnchantment,
    BlockHarvestModifierHook.MarkHarvesting {
        @Override
        default public int updateEnchantmentLevel(IToolStackView tool, ModifierEntry modifier, Enchantment enchantment, int level) {
            if (BlockHarvestModifierHook.MarkHarvesting.isHarvesting(tool)) {
                return SingleEnchantment.super.updateEnchantmentLevel(tool, modifier, enchantment, level);
            }
            return level;
        }

        @Override
        default public void updateEnchantments(IToolStackView tool, ModifierEntry modifier, Map<Enchantment, Integer> map) {
            if (BlockHarvestModifierHook.MarkHarvesting.isHarvesting(tool)) {
                SingleEnchantment.super.updateEnchantments(tool, modifier, map);
            }
        }
    }

    public static interface SingleEnchantment
    extends EnchantmentModifierHook {
        public Enchantment getEnchantment(IToolStackView var1, ModifierEntry var2);

        default public int getEnchantmentLevel(IToolStackView tool, ModifierEntry modifier) {
            return modifier.getLevel();
        }

        @Override
        default public int updateEnchantmentLevel(IToolStackView tool, ModifierEntry modifier, Enchantment enchantment, int level) {
            if (enchantment == this.getEnchantment(tool, modifier)) {
                level += this.getEnchantmentLevel(tool, modifier);
            }
            return level;
        }

        @Override
        default public void updateEnchantments(IToolStackView tool, ModifierEntry modifier, Map<Enchantment, Integer> map) {
            EnchantmentModifierHook.addEnchantment(map, this.getEnchantment(tool, modifier), this.getEnchantmentLevel(tool, modifier));
        }
    }

    public record AllMerger(Collection<EnchantmentModifierHook> modules) implements EnchantmentModifierHook
    {
        @Override
        public int updateEnchantmentLevel(IToolStackView tool, ModifierEntry modifier, Enchantment enchantment, int level) {
            for (EnchantmentModifierHook module : this.modules) {
                level = module.updateEnchantmentLevel(tool, modifier, enchantment, level);
            }
            return level;
        }

        @Override
        public void updateEnchantments(IToolStackView tool, ModifierEntry modifier, Map<Enchantment, Integer> map) {
            for (EnchantmentModifierHook module : this.modules) {
                module.updateEnchantments(tool, modifier, map);
            }
        }
    }
}

