/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.entity;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.recipe.TagPredicate;

public record PotionFluidEffect(float scale, TagPredicate predicate) implements FluidEffect<FluidEffectContext.Entity>
{
    public static final RecordLoadable<PotionFluidEffect> LOADER = RecordLoadable.create((RecordField)FloatLoadable.FROM_ZERO.requiredField("scale", e -> Float.valueOf(e.scale)), (RecordField)TagPredicate.LOADABLE.defaultField("nbt", (Object)TagPredicate.ANY, e -> e.predicate), PotionFluidEffect::new);

    public RecordLoadable<PotionFluidEffect> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Entity context, IFluidHandler.FluidAction action) {
        List effects;
        LivingEntity target = context.getLivingTarget();
        LivingEntity attacker = context.getEntity();
        if (target != null && this.predicate.test(fluid.getTag()) && !(effects = PotionUtils.m_43577_((CompoundTag)fluid.getTag()).m_43488_()).isEmpty()) {
            int oldInvulnerableTime = target.f_19802_;
            float used = 0.0f;
            for (MobEffectInstance instance : effects) {
                int duration;
                MobEffect effect = instance.m_19544_();
                if (effect.m_8093_()) {
                    used = level.value();
                    if (!action.execute()) continue;
                    target.f_19802_ = 0;
                    effect.m_19461_((Entity)attacker, (Entity)attacker, target, instance.m_19564_(), (double)(used * this.scale));
                    continue;
                }
                MobEffectInstance existingEffect = target.m_21124_(effect);
                if (existingEffect != null && existingEffect.m_19564_() >= instance.m_19564_()) {
                    float existingLevel = (float)existingEffect.m_19557_() / this.scale / (float)instance.m_19557_();
                    float effective = level.effective(existingLevel);
                    if (effective <= existingLevel) continue;
                    duration = (int)((float)instance.m_19557_() * this.scale * effective);
                    used = Math.max(used, effective - existingLevel);
                } else {
                    used = level.value();
                    duration = (int)((float)instance.m_19557_() * this.scale * used);
                }
                if (!action.execute()) continue;
                target.m_7292_(new MobEffectInstance(effect, duration, instance.m_19564_(), instance.m_19571_(), instance.m_19572_(), instance.m_19575_()));
            }
            target.f_19802_ = oldInvulnerableTime;
            return used;
        }
        return 0.0f;
    }
}

