/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.entity;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidMobEffect;
import slimeknights.tconstruct.library.modifiers.fluid.TimeAction;

public record MobEffectFluidEffect(FluidMobEffect effect, TimeAction action) implements FluidEffect<FluidEffectContext.Entity>
{
    public static final RecordLoadable<MobEffectFluidEffect> LOADER = RecordLoadable.create((RecordField)FluidMobEffect.LOADABLE.directField(e -> e.effect), (RecordField)TimeAction.LOADABLE.requiredField("action", e -> e.action), MobEffectFluidEffect::new);

    public RecordLoadable<MobEffectFluidEffect> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel scale, FluidEffectContext.Entity context, IFluidHandler.FluidAction action) {
        LivingEntity target = context.getLivingTarget();
        if (target != null) {
            float used;
            int time;
            MobEffectInstance existingInstance = target.m_21124_(this.effect.effect());
            if (existingInstance != null && existingInstance.m_19564_() >= this.effect.amplifier()) {
                if (this.action == TimeAction.ADD) {
                    int extraTime = (int)((float)this.effect.time() * scale.value());
                    if (extraTime <= 0) {
                        return 0.0f;
                    }
                    time = existingInstance.m_19557_() + extraTime;
                    used = scale.value();
                } else {
                    float existing = (float)existingInstance.m_19557_() / (float)this.effect.time();
                    float effective = scale.effective(existing);
                    if (effective < existing) {
                        return 0.0f;
                    }
                    used = effective - existing;
                    time = (int)((float)this.effect.time() * effective);
                }
            } else {
                time = (int)((float)this.effect.time() * scale.value());
                used = scale.value();
            }
            if (time > 0) {
                MobEffectInstance newInstance = this.effect.effectWithTime(time);
                if (action.simulate()) {
                    return target.m_7301_(newInstance) ? used : 0.0f;
                }
                return target.m_7292_(newInstance) ? used : 0.0f;
            }
        }
        return 0.0f;
    }
}

