/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.block;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.block.MobEffectCloudFluidEffect;
import slimeknights.tconstruct.library.recipe.TagPredicate;

public record PotionCloudFluidEffect(float scale, TagPredicate predicate) implements FluidEffect<FluidEffectContext.Block>
{
    public static final RecordLoadable<PotionCloudFluidEffect> LOADER = RecordLoadable.create((RecordField)FloatLoadable.FROM_ZERO.requiredField("scale", e -> Float.valueOf(e.scale)), (RecordField)TagPredicate.LOADABLE.defaultField("nbt", (Object)TagPredicate.ANY, e -> e.predicate), PotionCloudFluidEffect::new);

    public RecordLoadable<PotionCloudFluidEffect> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Block context, IFluidHandler.FluidAction action) {
        Potion potion;
        List effects;
        CompoundTag tag = fluid.getTag();
        if (this.predicate.test(tag) && context.isOffsetReplaceable() && !(effects = (potion = PotionUtils.m_43577_((CompoundTag)fluid.getTag())).m_43488_()).isEmpty()) {
            float scale = level.value();
            if (action.execute()) {
                AreaEffectCloud cloud = MobEffectCloudFluidEffect.makeCloud(context);
                float effectScale = this.scale * scale;
                boolean used = false;
                for (MobEffectInstance instance : effects) {
                    if (instance.m_19544_().m_8093_()) {
                        int amplifier = (int)((float)(instance.m_19564_() + 1) * effectScale * 2.0f) - 1;
                        if (amplifier < 0) continue;
                        cloud.m_19716_(new MobEffectInstance(instance.m_19544_(), instance.m_19557_(), amplifier, instance.m_19571_(), instance.m_19572_(), instance.m_19575_()));
                        used = true;
                        continue;
                    }
                    int duration = (int)((float)instance.m_19557_() * effectScale);
                    if (duration <= 10) continue;
                    cloud.m_19716_(new MobEffectInstance(instance.m_19544_(), duration, instance.m_19564_(), instance.m_19571_(), instance.m_19572_(), instance.m_19575_()));
                    used = true;
                }
                if (used) {
                    context.getLevel().m_7967_((Entity)cloud);
                } else {
                    cloud.m_146870_();
                    return 0.0f;
                }
            }
            return scale;
        }
        return 0.0f;
    }
}

