/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.enchantment.Enchantment;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ArmorWalkModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.DamageBlockModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.ElytraFlightModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.ModifyDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.EnchantmentModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.RepairFactorModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolActionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierTraitHook;
import slimeknights.tconstruct.library.modifiers.hook.build.RawDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.ArmorLootingModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.DamageDealtModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.LootingModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DisplayNameModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.RequirementsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.EntityInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.KeybindInteractModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.HarvestEnchantmentsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.RemoveBlockModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.BowAmmoModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.BlockTransformModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.PlantHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.ShearsModifierHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;

public class TinkerHooks {
    public static final ModifierHook<ConditionalStatModifierHook> CONDITIONAL_STAT = TinkerHooks.register("conditional_stat", ConditionalStatModifierHook.class, ConditionalStatModifierHook.AllMerger::new, (tool, modifier, living, stat, baseValue, multiplier) -> baseValue);
    public static final ModifierHook<ToolActionModifierHook> TOOL_ACTION = TinkerHooks.register("tool_action", ToolActionModifierHook.class, ToolActionModifierHook.AnyMerger::new, (tool, modifier, toolAction) -> false);
    public static final ModifierHook<EquipmentChangeModifierHook> EQUIPMENT_CHANGE = TinkerHooks.register("equipment_change", EquipmentChangeModifierHook.class, EquipmentChangeModifierHook.AllMerger::new, new EquipmentChangeModifierHook(){});
    public static final ModifierHook<RepairFactorModifierHook> REPAIR_FACTOR = TinkerHooks.register("repair_factor", RepairFactorModifierHook.class, RepairFactorModifierHook.ComposeMerger::new, (tool, entry, factor) -> factor);
    public static final ModifierHook<ToolDamageModifierHook> TOOL_DAMAGE = TinkerHooks.register("tool_damage", ToolDamageModifierHook.class, ToolDamageModifierHook.Merger::new, (tool, modifier, amount, holder) -> amount);
    public static final ModifierHook<InventoryTickModifierHook> INVENTORY_TICK = TinkerHooks.register("inventory_tick", InventoryTickModifierHook.class, InventoryTickModifierHook.AllMerger::new, (tool, modifier, world, holder, itemSlot, isSelected, isCorrectSlot, stack) -> {});
    public static final ModifierHook<DisplayNameModifierHook> DISPLAY_NAME = TinkerHooks.register("display_name", DisplayNameModifierHook.class, DisplayNameModifierHook.ComposeMerger::new, (tool, entry, name) -> name);
    public static final ModifierHook<TooltipModifierHook> TOOLTIP = TinkerHooks.register("tooltip", TooltipModifierHook.class, TooltipModifierHook.AllMerger::new, (tool, modifier, player, tooltip, tooltipKey, tooltipFlag) -> {});
    public static final ModifierHook<DurabilityDisplayModifierHook> DURABILITY_DISPLAY = TinkerHooks.register("durability_display", DurabilityDisplayModifierHook.class, DurabilityDisplayModifierHook.FirstMerger::new, new DurabilityDisplayModifierHook(){

        @Override
        @Nullable
        public Boolean showDurabilityBar(IToolStackView tool, ModifierEntry modifier) {
            return null;
        }

        @Override
        public int getDurabilityWidth(IToolStackView tool, ModifierEntry modifier) {
            return 0;
        }

        @Override
        public int getDurabilityRGB(IToolStackView tool, ModifierEntry modifier) {
            return -1;
        }
    });
    public static final ModifierHook<RequirementsModifierHook> REQUIREMENTS = TinkerHooks.register("requirements", RequirementsModifierHook.class, RequirementsModifierHook.FirstMerger::new, new RequirementsModifierHook(){});
    public static final ModifierHook<ToolStatsModifierHook> TOOL_STATS = TinkerHooks.register("tool_stats", ToolStatsModifierHook.class, ToolStatsModifierHook.AllMerger::new, (context, modifier, builder) -> {});
    public static final ModifierHook<AttributesModifierHook> ATTRIBUTES = TinkerHooks.register("attributes", AttributesModifierHook.class, AttributesModifierHook.AllMerger::new, (tool, modifier, slot, consumer) -> {});
    public static final ModifierHook<EnchantmentModifierHook> ENCHANTMENTS = TinkerHooks.register("enchantments", EnchantmentModifierHook.class, EnchantmentModifierHook.AllMerger::new, new EnchantmentModifierHook(){

        @Override
        public int updateEnchantmentLevel(IToolStackView tool, ModifierEntry modifier, Enchantment enchantment, int level) {
            return level;
        }

        @Override
        public void updateEnchantments(IToolStackView tool, ModifierEntry modifier, Map<Enchantment, Integer> map) {
        }
    });
    public static final ModifierHook<VolatileDataModifierHook> VOLATILE_DATA = TinkerHooks.register("volatile_data", VolatileDataModifierHook.class, VolatileDataModifierHook.AllMerger::new, (context, modifier, volatileData) -> {});
    public static final ModifierHook<RawDataModifierHook> RAW_DATA = TinkerHooks.register("raw_data", RawDataModifierHook.class, RawDataModifierHook.AllMerger::new, new RawDataModifierHook(){

        @Override
        public void addRawData(IToolStackView tool, ModifierEntry modifier, RestrictedCompoundTag tag) {
        }

        @Override
        public void removeRawData(IToolStackView tool, Modifier modifier, RestrictedCompoundTag tag) {
        }
    });
    public static final ModifierHook<ValidateModifierHook> VALIDATE = TinkerHooks.register("validate", ValidateModifierHook.class, ValidateModifierHook.AllMerger::new, (tool, modifier) -> null);
    public static final ModifierHook<ModifierRemovalHook> REMOVE = TinkerHooks.register("remove", ModifierRemovalHook.class, ModifierRemovalHook.FirstMerger::new, (tool, modifier) -> null);
    public static final ModifierHook<ModifierTraitHook> MODIFIER_TRAITS = TinkerHooks.register("modifier_traits", ModifierTraitHook.class, ModifierTraitHook.AllMerger::new, (context, modifier, builder, firstEncounter) -> {});
    public static final ModifierHook<MeleeDamageModifierHook> MELEE_DAMAGE = TinkerHooks.register("melee_damage", MeleeDamageModifierHook.class, MeleeDamageModifierHook.AllMerger::new, (tool, modifier, context, baseDamage, damage) -> damage);
    public static final ModifierHook<MeleeHitModifierHook> MELEE_HIT = TinkerHooks.register("melee_hit", MeleeHitModifierHook.class, MeleeHitModifierHook.AllMerger::new, new MeleeHitModifierHook(){});
    public static final ModifierHook<ProtectionModifierHook> PROTECTION = TinkerHooks.register("protection", ProtectionModifierHook.class, ProtectionModifierHook.AllMerger::new, (tool, modifier, context, slotType, source, modifierValue) -> modifierValue);
    public static final ModifierHook<DamageBlockModifierHook> DAMAGE_BLOCK = TinkerHooks.register("damage_block", DamageBlockModifierHook.class, DamageBlockModifierHook.AnyMerger::new, (tool, modifier, context, slotType, source, amount) -> false);
    public static final ModifierHook<OnAttackedModifierHook> ON_ATTACKED = TinkerHooks.register("on_attacked", OnAttackedModifierHook.class, OnAttackedModifierHook.AllMerger::new, (tool, modifier, context, slotType, source, amount, isDirectDamage) -> {});
    public static final ModifierHook<ModifyDamageModifierHook> MODIFY_HURT;
    public static final ModifierHook<ModifyDamageModifierHook> MODIFY_DAMAGE;
    public static final ModifierHook<DamageDealtModifierHook> DAMAGE_DEALT;
    public static final ModifierHook<LootingModifierHook> WEAPON_LOOTING;
    public static final ModifierHook<ArmorLootingModifierHook> ARMOR_LOOTING;
    public static final ModifierHook<HarvestEnchantmentsModifierHook> HARVEST_ENCHANTMENTS;
    public static final ModifierHook<BreakSpeedModifierHook> BREAK_SPEED;
    public static final ModifierHook<RemoveBlockModifierHook> REMOVE_BLOCK;
    public static final ModifierHook<BlockBreakModifierHook> BLOCK_BREAK;
    public static final ModifierHook<BlockHarvestModifierHook> BLOCK_HARVEST;
    public static final ModifierHook<ProjectileLaunchModifierHook> PROJECTILE_LAUNCH;
    public static final ModifierHook<ProjectileHitModifierHook> PROJECTILE_HIT;
    public static final ModifierHook<BowAmmoModifierHook> BOW_AMMO;
    public static final ModifierHook<ElytraFlightModifierHook> ELYTRA_FLIGHT;
    public static final ModifierHook<ArmorWalkModifierHook> BOOT_WALK;
    public static final ModifierHook<GeneralInteractionModifierHook> GENERAL_INTERACT;
    public static final ModifierHook<BlockInteractionModifierHook> BLOCK_INTERACT;
    public static final ModifierHook<EntityInteractionModifierHook> ENTITY_INTERACT;
    public static final ModifierHook<KeybindInteractModifierHook> ARMOR_INTERACT;
    public static final ModifierHook<PlantHarvestModifierHook> PLANT_HARVEST;
    public static final ModifierHook<ShearsModifierHook> SHEAR_ENTITY;
    public static final ModifierHook<BlockTransformModifierHook> BLOCK_TRANSFORM;

    private TinkerHooks() {
    }

    public static void init() {
    }

    private static <T> ModifierHook<T> register(String name, Class<T> filter, @Nullable Function<Collection<T>, T> merger, T defaultInstance) {
        return ModifierHooks.register(TConstruct.getResource(name), filter, defaultInstance, merger);
    }

    private static <T> ModifierHook<T> register(String name, Class<T> filter, T defaultInstance) {
        return TinkerHooks.register(name, filter, null, defaultInstance);
    }

    static {
        Function<Collection, ModifyDamageModifierHook> merger = ModifyDamageModifierHook.AllMerger::new;
        ModifyDamageModifierHook fallback = (tool, modifier, context, slotType, source, amount, isDirectDamage) -> amount;
        MODIFY_HURT = TinkerHooks.register("modify_hurt", ModifyDamageModifierHook.class, merger, fallback);
        MODIFY_DAMAGE = TinkerHooks.register("modify_damage", ModifyDamageModifierHook.class, merger, fallback);
        DAMAGE_DEALT = TinkerHooks.register("damage_dealt", DamageDealtModifierHook.class, DamageDealtModifierHook.AllMerger::new, (tool, modifier, context, slotType, target, source, amount, isDirectDamage) -> {});
        WEAPON_LOOTING = TinkerHooks.register("weapon_looting", LootingModifierHook.class, LootingModifierHook.ComposeMerger::new, (tool, modifier, context, looting) -> looting);
        ARMOR_LOOTING = TinkerHooks.register("armor_looting", ArmorLootingModifierHook.class, ArmorLootingModifierHook.ComposeMerger::new, (tool, modifier, context, equipment, slot, looting) -> looting);
        HARVEST_ENCHANTMENTS = TinkerHooks.register("harvest_enchantments", HarvestEnchantmentsModifierHook.class, HarvestEnchantmentsModifierHook.AllMerger::new, (tool, modifier, context, equipment, slot, map) -> {});
        BREAK_SPEED = TinkerHooks.register("break_speed", BreakSpeedModifierHook.class, BreakSpeedModifierHook.AllMerger::new, (tool, modifier, event, sideHit, isEffective, miningSpeedModifier) -> {});
        REMOVE_BLOCK = TinkerHooks.register("remove_block", RemoveBlockModifierHook.class, RemoveBlockModifierHook.FirstMerger::new, (tool, modifier, context) -> null);
        BLOCK_BREAK = TinkerHooks.register("block_break", BlockBreakModifierHook.class, BlockBreakModifierHook.AllMerger::new, (tool, modifier, context) -> {});
        BLOCK_HARVEST = TinkerHooks.register("block_harvest", BlockHarvestModifierHook.class, BlockHarvestModifierHook.AllMerger::new, (tool, modifier, context, didHarvest) -> {});
        PROJECTILE_LAUNCH = TinkerHooks.register("projectile_launch", ProjectileLaunchModifierHook.class, ProjectileLaunchModifierHook.ALL_MERGER, ProjectileLaunchModifierHook.EMPTY);
        PROJECTILE_HIT = TinkerHooks.register("projectile_hit", ProjectileHitModifierHook.class, ProjectileHitModifierHook.FIRST_MERGER, ProjectileHitModifierHook.EMPTY);
        BOW_AMMO = TinkerHooks.register("bow_ammo", BowAmmoModifierHook.class, BowAmmoModifierHook.EMPTY);
        ELYTRA_FLIGHT = TinkerHooks.register("elytra_flight", ElytraFlightModifierHook.class, ElytraFlightModifierHook.FIRST_MERGER, (tool, modifier, entity, flightTicks) -> false);
        BOOT_WALK = TinkerHooks.register("boot_walk", ArmorWalkModifierHook.class, ArmorWalkModifierHook.ALL_MERGER, (tool, modifier, living, prevPos, newPos) -> {});
        GENERAL_INTERACT = TinkerHooks.register("general_interact", GeneralInteractionModifierHook.class, GeneralInteractionModifierHook.FirstMerger::new, (tool, modifier, player, hand, source) -> InteractionResult.PASS);
        BLOCK_INTERACT = TinkerHooks.register("block_interact", BlockInteractionModifierHook.class, BlockInteractionModifierHook.FirstMerger::new, new BlockInteractionModifierHook(){});
        ENTITY_INTERACT = TinkerHooks.register("entity_interact", EntityInteractionModifierHook.class, EntityInteractionModifierHook.FirstMerger::new, new EntityInteractionModifierHook(){});
        ARMOR_INTERACT = TinkerHooks.register("armor_interact", KeybindInteractModifierHook.class, KeybindInteractModifierHook.MERGER, new KeybindInteractModifierHook(){});
        PLANT_HARVEST = TinkerHooks.register("plant_harvest", PlantHarvestModifierHook.class, PlantHarvestModifierHook.ALL_MERGER, (tool, modifier, context, world, state, pos) -> {});
        SHEAR_ENTITY = TinkerHooks.register("shear_entity", ShearsModifierHook.class, ShearsModifierHook.ALL_MERGER, (tool, modifier, player, entity, isTarget) -> {});
        BLOCK_TRANSFORM = TinkerHooks.register("block_transform", BlockTransformModifierHook.class, BlockTransformModifierHook.ALL_MERGER, BlockTransformModifierHook.EMPTY);
    }
}

