/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.IncrementalModifierEntry;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;

public class ModifierEntry
implements Comparable<ModifierEntry> {
    public static final String TAG_MODIFIER = "name";
    public static final String TAG_LEVEL = "level";
    public static final String TAG_AMOUNT = "amount";
    public static final String TAG_NEEDED = "needed";
    public static final String TAG_EFFECTIVE = "effective";
    public static final ModifierEntry EMPTY = new ModifierEntry(ModifierManager.EMPTY, 0);
    public static final RecordLoadable<ModifierEntry> LOADABLE = RecordLoadable.create((RecordField)ModifierId.PARSER.requiredField("name", ModifierEntry::getId), (RecordField)IntLoadable.FROM_ONE.defaultField("level", (Object)1, true, ModifierEntry::getLevel), ModifierEntry::new);
    public static final IntRange ANY_LEVEL = new IntRange(0, Short.MAX_VALUE);
    public static final IntRange VALID_LEVEL = new IntRange(1, Short.MAX_VALUE);
    protected final LazyModifier modifier;
    protected final int level;

    public ModifierEntry(ModifierId id, int level) {
        this(new LazyModifier(id), level);
    }

    public ModifierEntry(Modifier modifier, int level) {
        this(new LazyModifier(modifier), level);
    }

    public boolean isBound() {
        return this.modifier.isBound();
    }

    public ModifierId getId() {
        return this.modifier.getId();
    }

    public Modifier getModifier() {
        return this.modifier.get();
    }

    public LazyModifier getLazyModifier() {
        return this.modifier;
    }

    public final <T> T getHook(ModifierHook<T> hook) {
        return this.modifier.get().getHook(hook);
    }

    public float getEffectiveLevel() {
        return this.level;
    }

    public int intEffectiveLevel() {
        return this.level;
    }

    public int getAmount(int fallback) {
        return fallback;
    }

    public int getNeeded() {
        return 0;
    }

    public Component getDisplayName() {
        return this.modifier.get().getDisplayName(this.level);
    }

    public ModifierEntry addAmount(int amount, int needed) {
        if (needed <= 0 || amount <= 0) {
            return this;
        }
        return IncrementalModifierEntry.of(this.modifier, this.level + 1, amount, needed);
    }

    public ModifierEntry merge(ModifierEntry other) {
        if (!this.getId().equals((Object)other.getId())) {
            throw new IllegalArgumentException("Modifiers do not match, have " + this.getId() + " but was given " + other.getId());
        }
        return other.withLevel(this.level + other.level);
    }

    public boolean matches(ModifierId id) {
        return this.modifier.getId().equals((Object)id);
    }

    public boolean matches(Modifier modifier) {
        return this.matches(modifier.getId());
    }

    public boolean matches(TagKey<Modifier> tag) {
        return this.modifier.is(tag);
    }

    @Override
    public int compareTo(ModifierEntry other) {
        int priority2;
        Modifier mod1 = this.getModifier();
        Modifier mod2 = other.getModifier();
        int priority1 = mod1.getPriority();
        if (priority1 != (priority2 = mod2.getPriority())) {
            return Integer.compare(priority2, priority1);
        }
        return mod1.getId().m_135815_().compareTo(mod2.getId().m_135815_());
    }

    public static ModifierEntry readFromNBT(CompoundTag tag) {
        if (tag.m_128425_(TAG_MODIFIER, 8)) {
            ModifierId id = ModifierId.tryParse(tag.m_128461_(TAG_MODIFIER));
            int level = tag.m_128451_(TAG_LEVEL);
            if (id != null && level > 0) {
                return IncrementalModifierEntry.of(id, level, tag.m_128451_(TAG_AMOUNT), tag.m_128451_(TAG_NEEDED));
            }
        }
        return EMPTY;
    }

    public CompoundTag serializeToNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(TAG_MODIFIER, this.modifier.getId().toString());
        tag.m_128405_(TAG_LEVEL, this.level);
        return tag;
    }

    @Deprecated
    public static ModifierEntry read(FriendlyByteBuf buffer) {
        return (ModifierEntry)LOADABLE.decode(buffer);
    }

    @Deprecated
    public void write(FriendlyByteBuf buffer) {
        LOADABLE.encode(buffer, (Object)this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifierEntry entry = (ModifierEntry)o;
        return this.matches(entry.getId()) && this.level == entry.level;
    }

    public int hashCode() {
        return 31 * this.modifier.hashCode() + this.level;
    }

    public String toString() {
        return "ModifierEntry{" + this.modifier.getId() + ",level=" + this.level + "}";
    }

    public ModifierEntry(LazyModifier modifier, int level) {
        this.modifier = modifier;
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public ModifierEntry withLevel(int level) {
        return this.level == level ? this : new ModifierEntry(this.modifier, level);
    }
}

