/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.stats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.utils.Util;

public class UpdateMaterialStatsPacket
implements IThreadsafePacket {
    private static final Logger log = Util.getLogger("NetworkSync");
    protected final Map<MaterialId, Collection<IMaterialStats>> materialToStats;

    public UpdateMaterialStatsPacket(FriendlyByteBuf buffer) {
        this(buffer, MaterialRegistry::getStatDecoder);
    }

    public UpdateMaterialStatsPacket(FriendlyByteBuf buffer, Function<MaterialStatsId, Function<FriendlyByteBuf, ? extends IMaterialStats>> decoderResolver) {
        int materialCount = buffer.readInt();
        this.materialToStats = new HashMap<MaterialId, Collection<IMaterialStats>>(materialCount);
        for (int i = 0; i < materialCount; ++i) {
            MaterialId id = new MaterialId(buffer.m_130281_());
            int statCount = buffer.readInt();
            ArrayList statList = new ArrayList();
            for (int j = 0; j < statCount; ++j) {
                this.decodeStat(buffer, decoderResolver).ifPresent(statList::add);
            }
            this.materialToStats.put(id, statList);
        }
    }

    private Optional<IMaterialStats> decodeStat(FriendlyByteBuf buffer, Function<MaterialStatsId, Function<FriendlyByteBuf, ? extends IMaterialStats>> decoderResolver) {
        MaterialStatsId statsId = new MaterialStatsId(buffer.m_130281_());
        try {
            Function<FriendlyByteBuf, ? extends IMaterialStats> decoder = decoderResolver.apply(statsId);
            if (decoder == null) {
                log.error("Unknown stat type {}. Are client and server in sync?", (Object)statsId);
                return Optional.empty();
            }
            return Optional.of(decoder.apply(buffer));
        }
        catch (Exception e) {
            log.error("Could not load class for deserialization of stats {}. Are client and server in sync?", (Object)statsId, (Object)e);
            return Optional.empty();
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.materialToStats.size());
        this.materialToStats.forEach((materialId, stats) -> {
            buffer.m_130085_((ResourceLocation)materialId);
            buffer.writeInt(stats.size());
            stats.forEach(stat -> this.encodeStat(buffer, (IMaterialStats)stat));
        });
    }

    private void encodeStat(FriendlyByteBuf buffer, IMaterialStats stat) {
        buffer.m_130085_((ResourceLocation)stat.getIdentifier());
        stat.encode(buffer);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        MaterialRegistry.updateMaterialStatsFromServer(this);
    }

    public Map<MaterialId, Collection<IMaterialStats>> getMaterialToStats() {
        return this.materialToStats;
    }

    public UpdateMaterialStatsPacket(Map<MaterialId, Collection<IMaterialStats>> materialToStats) {
        this.materialToStats = materialToStats;
    }
}

