/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.field;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.NullableField;

public record MergingListField<T, P>(LoadableField<T, T> field, String key, Function<P, List<T>> getter) implements LoadableField<List<T>, P>
{
    public MergingListField {
        if (field instanceof NullableField) {
            throw new IllegalArgumentException("Merging list field does not support nulls, use a defaulting field with an appropriate default instead");
        }
    }

    public List<T> get(JsonObject json) {
        if (json.has(this.key)) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)this.key);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject element = GsonHelper.m_13918_((JsonElement)array.get(i), (String)(this.key + "[" + i + "]"));
                builder.add(this.field.get(element));
            }
            return builder.build();
        }
        return List.of();
    }

    public void serialize(P parent, JsonObject json) {
        List<T> objects = this.getter.apply(parent);
        if (json.has(this.key)) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)this.key);
            int size = objects.size();
            if (array.size() < size) {
                throw new RuntimeException("Too many elements in list to merge into parent: have " + size + " but limited to " + array.size());
            }
            for (int i = 0; i < size; ++i) {
                JsonObject element = GsonHelper.m_13918_((JsonElement)array.get(i), (String)(this.key + "[" + i + "]"));
                this.field.serialize(objects.get(i), element);
            }
        }
    }

    public List<T> decode(FriendlyByteBuf buffer) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            builder.add(this.field.decode(buffer));
        }
        return builder.build();
    }

    public void encode(FriendlyByteBuf buffer, P parent) {
        List<T> list = this.getter.apply(parent);
        buffer.m_130130_(list.size());
        for (T value : list) {
            this.field.encode(buffer, value);
        }
    }
}

