/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.material;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialDataProvider;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.materials.traits.MaterialTraits;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;

public abstract class AbstractMaterialTraitDataProvider
extends GenericDataProvider {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ModifierEntry.class, ModifierEntry.LOADABLE).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<MaterialId, MaterialTraits.Builder> allMaterialTraits = new HashMap<MaterialId, MaterialTraits.Builder>();
    private final AbstractMaterialDataProvider materials;

    public AbstractMaterialTraitDataProvider(DataGenerator gen, AbstractMaterialDataProvider materials) {
        super(gen, PackType.SERVER_DATA, "tinkering/materials/traits", GSON);
        this.materials = materials;
    }

    protected abstract void addMaterialTraits();

    public void m_213708_(CachedOutput cache) {
        this.addMaterialTraits();
        Set<MaterialId> materialsGenerated = this.materials.getAllMaterials();
        for (MaterialId material : materialsGenerated) {
            if (this.allMaterialTraits.containsKey(material)) continue;
            throw new IllegalStateException(String.format("Missing material traits for '%s'", material));
        }
        this.allMaterialTraits.forEach((materialId, traits) -> this.saveJson(cache, (ResourceLocation)materialId, traits.serialize()));
    }

    private MaterialTraits.Builder getOrCreateMaterialTraits(MaterialId location) {
        return this.allMaterialTraits.computeIfAbsent(location, id -> new MaterialTraits.Builder());
    }

    protected void noTraits(MaterialId location) {
        this.getOrCreateMaterialTraits(location);
    }

    protected void addDefaultTraits(MaterialId location, ModifierEntry ... traits) {
        this.getOrCreateMaterialTraits(location).setDefaultTraits(Arrays.asList(traits));
    }

    protected void addDefaultTraits(MaterialId location, ModifierId ... traits) {
        this.getOrCreateMaterialTraits(location).setDefaultTraits(Arrays.stream(traits).map(trait -> new ModifierEntry((ModifierId)((Object)trait), 1)).collect(Collectors.toList()));
    }

    protected void addDefaultTraits(MaterialId location, LazyModifier ... traits) {
        this.getOrCreateMaterialTraits(location).setDefaultTraits(Arrays.stream(traits).map(trait -> new ModifierEntry(trait.getId(), 1)).collect(Collectors.toList()));
    }

    protected void addTraits(MaterialId location, MaterialStatsId statsId, ModifierEntry ... traits) {
        this.getOrCreateMaterialTraits(location).setTraits(statsId, Arrays.asList(traits));
    }

    protected void addTraits(MaterialId location, MaterialStatsId statsId, ModifierId ... traits) {
        this.getOrCreateMaterialTraits(location).setTraits(statsId, Arrays.stream(traits).map(trait -> new ModifierEntry((ModifierId)((Object)trait), 1)).collect(Collectors.toList()));
    }

    protected void addTraits(MaterialId location, MaterialStatsId statsId, LazyModifier ... traits) {
        this.getOrCreateMaterialTraits(location).setTraits(statsId, Arrays.stream(traits).map(trait -> new ModifierEntry(trait.getId(), 1)).collect(Collectors.toList()));
    }
}

