/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import javax.annotation.Nullable;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.client.modifiers.FluidModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.capability.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class TankModifierModel
extends FluidModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        Material smallTexture = (Material)smallGetter.apply("");
        Material largeTexture = (Material)largeGetter.apply("");
        Material smallPartial = (Material)smallGetter.apply("_partial");
        Material largePartial = (Material)largeGetter.apply("_partial");
        Material smallFull = (Material)smallGetter.apply("_full");
        Material largeFull = (Material)largeGetter.apply("_full");
        if (smallTexture != null || largeTexture != null) {
            return new TankModifierModel(smallTexture, largeTexture, smallPartial, largePartial, smallFull, largeFull);
        }
        return null;
    };

    public TankModifierModel(@Nullable Material smallTexture, @Nullable Material largeTexture, @Nullable Material smallPartial, @Nullable Material largePartial, @Nullable Material smallFull, @Nullable Material largeFull) {
        super(smallTexture, largeTexture, new Material[]{smallPartial, largePartial, smallFull, largeFull});
    }

    @Override
    @Nullable
    public Object getCacheKey(IToolStackView tool, ModifierEntry entry) {
        ToolFluidCapability.FluidModifierHook tank = entry.getHook(ToolFluidCapability.HOOK);
        FluidStack fluid = tank.getFluidInTank(tool, entry, 0);
        if (!fluid.isEmpty()) {
            return new TankModifierCacheKey(entry.getModifier(), fluid.getFluid(), fluid.getAmount() < tank.getTankCapacity(tool, entry, 0));
        }
        return entry.getModifier();
    }

    @Override
    @Nullable
    protected Material getTemplate(ToolFluidCapability.FluidModifierHook tank, IToolStackView tool, ModifierEntry entry, FluidStack fluid, boolean isLarge) {
        boolean isFull = fluid.getAmount() == tank.getTankCapacity(tool, entry, 0);
        return this.fluidTextures[(isFull ? 2 : 0) | (isLarge ? 1 : 0)];
    }

    private record TankModifierCacheKey(Modifier modifier, Fluid fluid, boolean isPartial) {
    }
}

