/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.materials;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.gson.ResourceLocationSerializer;
import slimeknights.mantle.data.listener.IEarlySafeManagerReloadListener;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoJson;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialRenderInfoLoader
implements IEarlySafeManagerReloadListener {
    private static final Logger log = LogManager.getLogger(MaterialRenderInfoLoader.class);
    public static final MaterialRenderInfoLoader INSTANCE = new MaterialRenderInfoLoader();
    public static final String FOLDER = "tinkering/materials";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(MaterialStatsId.class, (Object)new ResourceLocationSerializer(MaterialStatsId::new, "tconstruct")).registerTypeHierarchyAdapter(ISpriteTransformer.class, ISpriteTransformer.SERIALIZER).registerTypeHierarchyAdapter(IColorMapping.class, IColorMapping.SERIALIZER).setPrettyPrinting().disableHtmlEscaping().create();
    private Map<MaterialVariantId, MaterialRenderInfo> renderInfos = ImmutableMap.of();

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, ModelEvent.RegisterAdditional.class, event -> {
            if (ModLoader.isLoadingStateValid()) {
                INSTANCE.onReloadSafe(Minecraft.m_91087_().m_91098_());
            }
        });
    }

    private MaterialRenderInfoLoader() {
    }

    public Collection<MaterialRenderInfo> getAllRenderInfos() {
        return this.renderInfos.values();
    }

    public Optional<MaterialRenderInfo> getRenderInfo(MaterialVariantId variantId) {
        MaterialRenderInfo info;
        if (variantId.hasVariant() && (info = this.renderInfos.get(variantId)) != null) {
            return Optional.of(info);
        }
        return Optional.ofNullable(this.renderInfos.get(variantId.getId()));
    }

    public void onReloadSafe(ResourceManager manager) {
        HashMap<MaterialVariantId, MaterialRenderInfo> map = new HashMap<MaterialVariantId, MaterialRenderInfo>();
        for (Map.Entry entry : manager.m_214159_(FOLDER, loc -> loc.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            String localPath = JsonHelper.localize((String)location.m_135815_(), (String)FOLDER, (String)".json");
            String variant = "";
            int slashIndex = localPath.lastIndexOf(47);
            if (slashIndex >= 0) {
                variant = localPath.substring(slashIndex + 1);
                localPath = localPath.substring(0, slashIndex);
            }
            MaterialVariantId id = MaterialVariantId.create(location.m_135827_(), localPath, variant);
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    MaterialRenderInfoJson json = (MaterialRenderInfoJson)GSON.fromJson((Reader)reader, MaterialRenderInfoJson.class);
                    if (json == null) {
                        log.error("Couldn't load data file {} from {} as it's null or empty", (Object)id, (Object)location);
                        continue;
                    }
                    MaterialRenderInfo old = map.put(id, this.loadRenderInfo(id, json));
                    if (old == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + id);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                log.error("Couldn't parse data file {} from {}", (Object)id, (Object)location, (Object)jsonparseexception);
            }
        }
        this.renderInfos = map;
        log.debug("Loaded material render infos: {}", (Object)Util.toIndentedStringList(map.keySet()));
        log.info("{} material render infos loaded", (Object)map.size());
    }

    private MaterialRenderInfo loadRenderInfo(MaterialVariantId material, MaterialRenderInfoJson json) {
        String[] fallback;
        int color = -1;
        if (json.getColor() != null) {
            color = JsonHelper.parseColor((String)json.getColor());
        }
        ResourceLocation texture = null;
        if (!json.isSkipUniqueTexture() && (texture = json.getTexture()) == null) {
            texture = material.getLocation('_');
        }
        if ((fallback = json.getFallbacks()) == null) {
            fallback = new String[]{};
        }
        return new MaterialRenderInfo(material, texture, fallback, color, json.getLuminosity());
    }
}

