/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.spritetransformer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.mojang.blaze3d.platform.NativeImage;
import java.lang.reflect.Type;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;

public class RecolorSpriteTransformer
implements ISpriteTransformer {
    public static final ResourceLocation NAME = TConstruct.getResource("recolor_sprite");
    public static final Deserializer DESERIALIZER = new Deserializer();
    private final IColorMapping colorMapping;

    @Override
    public void transform(NativeImage image) {
        for (int x = 0; x < image.m_84982_(); ++x) {
            for (int y = 0; y < image.m_85084_(); ++y) {
                image.m_84988_(x, y, this.colorMapping.mapColor(image.m_84985_(x, y)));
            }
        }
    }

    @Override
    public int getFallbackColor() {
        return this.colorMapping.mapColor(-2565928);
    }

    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("type", NAME.toString());
        object.add("color_mapping", context.serialize((Object)this.colorMapping));
        return object;
    }

    public RecolorSpriteTransformer(IColorMapping colorMapping) {
        this.colorMapping = colorMapping;
    }

    public IColorMapping getColorMapping() {
        return this.colorMapping;
    }

    protected static class Deserializer
    implements JsonDeserializer<RecolorSpriteTransformer> {
        protected Deserializer() {
        }

        public RecolorSpriteTransformer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            IColorMapping colorMapping = (IColorMapping)context.deserialize(JsonHelper.getElement((JsonObject)object, (String)"color_mapping"), IColorMapping.class);
            return new RecolorSpriteTransformer(colorMapping);
        }
    }
}

