/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data;

import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GenericTextureGenerator
implements DataProvider {
    private static final Logger log = LogManager.getLogger(GenericTextureGenerator.class);
    private final DataGenerator generator;
    @Nullable
    private final ExistingFileHelper existingFileHelper;
    private final String folder;
    @Nullable
    private final ExistingFileHelper.ResourceType resourceType;

    public GenericTextureGenerator(DataGenerator generator, @Nullable ExistingFileHelper existingFileHelper, String folder) {
        this.generator = generator;
        this.folder = folder;
        this.existingFileHelper = existingFileHelper;
        this.resourceType = existingFileHelper != null ? new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", folder) : null;
    }

    public GenericTextureGenerator(DataGenerator generator, String folder) {
        this(generator, null, folder);
    }

    protected void saveImage(CachedOutput cache, ResourceLocation location, NativeImage image) {
        try {
            Path path = this.generator.m_123916_().resolve(Paths.get(PackType.CLIENT_RESOURCES.m_10305_(), location.m_135827_(), this.folder, location.m_135815_() + ".png"));
            if (this.existingFileHelper != null && this.resourceType != null) {
                this.existingFileHelper.trackGenerated(location, (ExistingFileHelper.IResourceType)this.resourceType);
            }
            byte[] bytes = image.m_85121_();
            cache.m_213871_(path, bytes, Hashing.sha1().hashBytes(bytes));
        }
        catch (IOException e) {
            log.error("Couldn't write image for {}", (Object)location, (Object)e);
        }
    }

    protected void saveMetadata(CachedOutput cache, ResourceLocation location, JsonObject metadata) {
        try {
            Path path = this.generator.m_123916_().resolve(Paths.get(PackType.CLIENT_RESOURCES.m_10305_(), location.m_135827_(), this.folder, location.m_135815_() + ".png.mcmeta"));
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)metadata, (Path)path);
        }
        catch (IOException e) {
            log.error("Couldn't write image metadata for {}", (Object)location, (Object)e);
        }
    }
}

