/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.gadgets.entity.EFLNExplosion;
import slimeknights.tconstruct.tools.network.EntityMovementChangePacket;

public class Exploder {
    public final double r;
    private final double rr;
    public final int dist;
    private final double explosionStrength;
    private final int blocksPerIteration;
    public final int x;
    public final int y;
    public final int z;
    public final Level world;
    private final Entity exploder;
    private final EFLNExplosion explosion;
    private int currentRadius;
    private int curX;
    private int curY;
    private int curZ;
    private List<ItemStack> droppedItems;

    public Exploder(Level world, EFLNExplosion explosion, Entity exploder, BlockPos location, double r, double explosionStrength, int blocksPerIteration) {
        this.r = r;
        this.world = world;
        this.explosion = explosion;
        this.exploder = exploder;
        this.rr = r * r;
        this.dist = (int)r + 1;
        this.explosionStrength = explosionStrength;
        this.blocksPerIteration = blocksPerIteration;
        this.currentRadius = 0;
        this.x = location.m_123341_();
        this.y = location.m_123342_();
        this.z = location.m_123343_();
        this.curX = 0;
        this.curY = 0;
        this.curZ = 0;
        this.droppedItems = Lists.newArrayList();
    }

    public static void startExplosion(Level world, EFLNExplosion explosion, Entity entity, BlockPos location, double r, double explosionStrength) {
        Exploder exploder = new Exploder(world, explosion, entity, location, r, explosionStrength, Math.max(50, (int)(r * r * r / 10.0)));
        exploder.handleEntities();
        world.m_5594_(null, location, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.2f) * 0.7f);
        MinecraftForge.EVENT_BUS.register((Object)exploder);
    }

    private void handleEntities() {
        Predicate<Entity> predicate = entity -> entity != null && !entity.m_6128_() && EntitySelector.f_20408_.test(entity) && EntitySelector.f_20402_.test(entity) && entity.m_20182_().m_82531_((double)this.x, (double)this.y, (double)this.z) <= this.r * this.r;
        List list = this.world.m_6249_(this.exploder, new AABB((double)this.x - this.r - 1.0, (double)this.y - this.r - 1.0, (double)this.z - this.r - 1.0, (double)this.x + this.r + 1.0, (double)this.y + this.r + 1.0, (double)this.z + this.r + 1.0), predicate);
        ForgeEventFactory.onExplosionDetonate((Level)this.world, (Explosion)this.explosion, (List)list, (double)(this.r * 2.0));
        for (Entity entity2 : list) {
            Vec3 dir = entity2.m_20182_().m_82546_(this.exploder.m_20182_().m_82520_(0.0, -this.r / 2.0, 0.0));
            double str = (this.r - dir.m_82553_()) / this.r;
            str = Math.max(0.3, str);
            dir = dir.m_82541_();
            dir = dir.m_82490_(this.explosionStrength * str * 0.3);
            entity2.m_5997_(dir.f_82479_, dir.f_82480_ + 0.5, dir.f_82481_);
            entity2.m_6469_(DamageSource.m_19358_((Explosion)this.explosion), (float)(str * this.explosionStrength));
            if (!(entity2 instanceof ServerPlayer)) continue;
            TinkerNetwork.getInstance().sendTo(new EntityMovementChangePacket(entity2), (ServerPlayer)entity2);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.LevelTickEvent event) {
        if (event.level == this.world && event.phase == TickEvent.Phase.END && !this.iteration()) {
            this.finish();
        }
    }

    private void finish() {
        int d = (int)this.r / 2;
        BlockPos pos = new BlockPos(this.x - d, this.y - d, this.z - d);
        Random random = new Random();
        ArrayList aggregatedDrops = Lists.newArrayList();
        for (ItemStack drop : this.droppedItems) {
            boolean notInList = true;
            for (ItemStack stack : aggregatedDrops) {
                if (!ItemStack.m_41746_((ItemStack)drop, (ItemStack)stack) || !ItemStack.m_41658_((ItemStack)drop, (ItemStack)stack)) continue;
                stack.m_41769_(drop.m_41613_());
                notInList = false;
                break;
            }
            if (!notInList) continue;
            aggregatedDrops.add(drop);
        }
        for (ItemStack drop : aggregatedDrops) {
            ItemStack dropItemstack;
            int stacksize = drop.m_41613_();
            do {
                BlockPos spawnPos = pos.m_7918_(random.nextInt((int)this.r), random.nextInt((int)this.r), random.nextInt((int)this.r));
                dropItemstack = drop.m_41777_();
                dropItemstack.m_41764_(Math.min(stacksize, 64));
                Block.m_49840_((Level)this.world, (BlockPos)spawnPos, (ItemStack)dropItemstack);
            } while ((stacksize -= dropItemstack.m_41613_()) > 0);
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    private boolean iteration() {
        int count = 0;
        this.explosion.m_46080_();
        while (count < this.blocksPerIteration && this.currentRadius < (int)this.r + 1) {
            double d = this.curX * this.curX + this.curY * this.curY + this.curZ * this.curZ;
            if (d <= this.rr) {
                BlockPos blockpos = new BlockPos(this.x + this.curX, this.y + this.curY, this.z + this.curZ);
                BlockState blockState = this.world.m_8055_(blockpos);
                FluidState ifluidstate = this.world.m_6425_(blockpos);
                if (!blockState.m_60795_() || !ifluidstate.m_76178_()) {
                    double f = this.explosionStrength * (1.0 - d / this.rr);
                    float f2 = Math.max(blockState.getExplosionResistance((BlockGetter)this.world, blockpos, (Explosion)this.explosion), ifluidstate.getExplosionResistance((BlockGetter)this.world, blockpos, (Explosion)this.explosion));
                    if (this.exploder != null) {
                        f2 = this.exploder.m_7077_((Explosion)this.explosion, (BlockGetter)this.world, blockpos, blockState, ifluidstate, f2);
                    }
                    if ((f -= (double)((f2 + 0.3f) * 0.3f)) > 0.0 && (this.exploder == null || this.exploder.m_7349_((Explosion)this.explosion, (BlockGetter)this.world, blockpos, blockState, (float)f))) {
                        ++count;
                        this.explosion.addAffectedBlock(blockpos);
                    }
                }
            }
            this.step();
        }
        ForgeEventFactory.onExplosionDetonate((Level)this.world, (Explosion)this.explosion, Collections.emptyList(), (double)(this.r * 2.0));
        this.explosion.m_46081_().forEach(this::explodeBlock);
        return count == this.blocksPerIteration;
    }

    private void step() {
        if (++this.curX > this.currentRadius) {
            this.curX = -this.currentRadius;
            if (++this.curZ > this.currentRadius) {
                this.curZ = -this.currentRadius;
                if (--this.curY < -this.currentRadius) {
                    ++this.currentRadius;
                    this.curX = this.curZ = -this.currentRadius;
                    this.curY = this.currentRadius;
                }
            }
        }
        if (this.curY != -this.currentRadius && this.curY != this.currentRadius && this.curZ != -this.currentRadius && this.curZ != this.currentRadius && this.curX > -this.currentRadius) {
            this.curX = this.currentRadius;
        }
    }

    private void explodeBlock(BlockPos blockpos) {
        BlockState blockstate = this.world.m_8055_(blockpos);
        if (!this.world.f_46443_ && blockstate.canDropFromExplosion((BlockGetter)this.world, blockpos, (Explosion)this.explosion)) {
            BlockEntity tileentity = blockstate.m_155947_() ? this.world.m_7702_(blockpos) : null;
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.world).m_230911_(this.world.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)tileentity);
            this.droppedItems.addAll(blockstate.m_60724_(builder));
        }
        if (this.world instanceof ServerLevel) {
            for (ServerPlayer serverplayerentity : ((ServerLevel)this.world).m_6907_()) {
                ((ServerLevel)this.world).m_8624_(serverplayerentity, (ParticleOptions)ParticleTypes.f_123759_, true, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), 2, 0.0, 0.0, 0.0, 0.0);
                ((ServerLevel)this.world).m_8624_(serverplayerentity, (ParticleOptions)ParticleTypes.f_123762_, true, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        blockstate.onBlockExploded(this.world, blockpos, (Explosion)this.explosion);
    }
}

