/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.worldgen.islands.IslandStructure;

public class IslandPiece
extends TemplateStructurePiece {
    @Nullable
    private final ConfiguredFeature<?, ?> tree;
    private final IslandStructure structure;
    private int numberOfTreesPlaced;
    private ChunkGenerator chunkGenerator;

    public IslandPiece(StructureTemplateManager manager, IslandStructure structure, ResourceLocation templateName, BlockPos templatePos, @Nullable ConfiguredFeature<?, ?> tree, Rotation rotation, Mirror mirror) {
        super((StructurePieceType)TinkerStructures.islandPiece.get(), 0, manager, templateName, templateName.toString(), IslandPiece.makeSettings(rotation, mirror), templatePos);
        this.structure = structure;
        this.numberOfTreesPlaced = 0;
        this.tree = tree;
    }

    public IslandPiece(StructurePieceSerializationContext context, CompoundTag nbt) {
        super((StructurePieceType)TinkerStructures.islandPiece.get(), nbt, context.f_226956_(), id -> IslandPiece.makeSettings(Rotation.valueOf((String)nbt.m_128461_("Rot")), Mirror.valueOf((String)nbt.m_128461_("Mi"))));
        IslandStructure island;
        RegistryAccess access = context.f_192763_();
        Object t = IslandPiece.find(access.m_175515_(Registry.f_235725_), nbt.m_128461_("Structure"));
        this.structure = t instanceof IslandStructure ? (island = (IslandStructure)((Object)t)) : null;
        this.tree = (ConfiguredFeature)IslandPiece.find(access.m_175515_(Registry.f_122881_), nbt.m_128461_("Tree"));
        this.numberOfTreesPlaced = nbt.m_128451_("NumberOfTreesPlaced");
    }

    private static StructurePlaceSettings makeSettings(Rotation rotation, Mirror mirror) {
        return new StructurePlaceSettings().m_74392_(true).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_).m_74379_(rotation).m_74377_(mirror);
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        ResourceLocation key;
        super.m_183620_(context, tag);
        RegistryAccess access = context.f_192763_();
        ResourceLocation structure = access.m_175515_(Registry.f_235725_).m_7981_((Object)this.structure);
        if (structure != null) {
            tag.m_128359_("Structure", structure.toString());
        }
        tag.m_128359_("Rot", this.f_73657_.m_74404_().name());
        tag.m_128359_("Mi", this.f_73657_.m_74401_().name());
        tag.m_128405_("NumberOfTreesPlaced", this.numberOfTreesPlaced);
        if (this.tree != null && (key = access.m_175515_(Registry.f_122881_).m_7981_(this.tree)) != null) {
            tag.m_128359_("Tree", key.toString());
        }
    }

    protected void m_213704_(String function, BlockPos pos, ServerLevelAccessor level, RandomSource rand, BoundingBox sbb) {
        switch (function) {
            case "tconstruct:slime_vine": {
                Block vines = this.structure.getVines();
                if (vines == null || !rand.m_188499_()) break;
                IslandPiece.placeVine((LevelAccessor)level, pos, rand, vines.m_49966_());
                break;
            }
            case "tconstruct:slime_tree": {
                WorldGenLevel worldgenLevel;
                if (this.tree == null || this.numberOfTreesPlaced >= 3 || !rand.m_188499_() || !(level instanceof WorldGenLevel) || !this.tree.m_224953_(worldgenLevel = (WorldGenLevel)level, this.chunkGenerator, rand, pos)) break;
                ++this.numberOfTreesPlaced;
                break;
            }
            case "tconstruct:slime_tall_grass": {
                BushBlock bush;
                Optional plant;
                if (!rand.m_188499_() || !(plant = this.structure.getGrasses().m_216820_(rand)).isPresent()) break;
                Block block = (Block)plant.get();
                BlockState state = block.m_49966_();
                if (!(block instanceof BushBlock) || !(bush = (BushBlock)block).m_7898_(state, (LevelReader)level, pos)) break;
                level.m_7731_(pos, state, 2);
            }
        }
    }

    private static void placeVine(LevelAccessor worldIn, BlockPos pos, RandomSource random, BlockState vineToPlace) {
        BlockState state;
        Block block;
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN || !SlimeVineBlock.m_57853_((BlockGetter)worldIn, (BlockPos)pos.m_121945_(direction), (Direction)direction)) continue;
            worldIn.m_7731_(pos, (BlockState)vineToPlace.m_61124_((Property)SlimeVineBlock.m_57883_((Direction)direction), (Comparable)Boolean.TRUE), 2);
        }
        BlockPos vinePos = pos;
        for (int size = random.m_188503_(8); size >= 0 && (block = (state = worldIn.m_8055_(vinePos)).m_60734_()) instanceof SlimeVineBlock; --size) {
            SlimeVineBlock vine = (SlimeVineBlock)block;
            vine.grow(worldIn, random, vinePos, state);
            vinePos = vinePos.m_7495_();
        }
    }

    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox bounds, ChunkPos chunk, BlockPos pos) {
        this.chunkGenerator = generator;
        super.m_213694_(world, manager, generator, rand, bounds, chunk, pos);
    }

    private static <T> Registry<T> getRegistry(ResourceKey<? extends Registry<T>> registryKey, Registry<T> builtIn, StructurePieceSerializationContext context) {
        Optional registry = context.f_192763_().m_6632_(registryKey);
        if (registry.isPresent()) {
            return (Registry)registry.get();
        }
        return builtIn;
    }

    @Nullable
    private static <T> T find(Registry<T> registry, String key) {
        ResourceLocation id = ResourceLocation.m_135820_((String)key);
        if (id != null) {
            return (T)registry.m_7745_(id);
        }
        return null;
    }
}

