/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.worktable.AbstractWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierSortingRecipe
extends AbstractWorktableRecipe {
    private static final Component TITLE = TConstruct.makeTranslation("recipe", "modifier_sorting.title");
    private static final Component DESCRIPTION = TConstruct.makeTranslation("recipe", "modifier_sorting.description");
    private static final Component NOT_ENOUGH_MODIFIERS = TConstruct.makeTranslation("recipe", "modifier_sorting.not_enough_modifiers");
    public static final RecordLoadable<ModifierSortingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)INPUTS_FIELD, ModifierSortingRecipe::new);

    public ModifierSortingRecipe(ResourceLocation id, List<SizedIngredient> inputs) {
        super(id, inputs);
    }

    @Override
    public boolean matches(ITinkerableContainer inv, Level world) {
        if (!inv.getTinkerableStack().m_204117_(TinkerTags.Items.MODIFIABLE)) {
            return false;
        }
        return ModifierRecipe.checkMatch(inv, this.inputs);
    }

    @Override
    public Component getTitle() {
        return TITLE;
    }

    @Override
    public Component getDescription(@Nullable ITinkerableContainer inv) {
        if (inv != null && inv.getTinkerable().getUpgrades().getModifiers().size() < 2) {
            return NOT_ENOUGH_MODIFIERS;
        }
        return DESCRIPTION;
    }

    @Override
    public RecipeResult<ToolStack> getResult(ITinkerableContainer inv, ModifierEntry modifier) {
        ToolStack tool = inv.getTinkerable();
        List<ModifierEntry> upgrades = tool.getUpgrades().getModifiers();
        int toMove = IntStream.range(0, upgrades.size()).filter(i -> ((ModifierEntry)upgrades.get(i)).matches(modifier.getId())).findFirst().orElse(-1);
        if (toMove == -1) {
            return RecipeResult.pass();
        }
        tool = tool.copy();
        ArrayList<ModifierEntry> newUpgrades = new ArrayList<ModifierEntry>(upgrades);
        Collections.swap(newUpgrades, toMove, toMove == upgrades.size() - 1 ? 0 : toMove + 1);
        tool.setUpgrades(new ModifierNBT(newUpgrades));
        return RecipeResult.success(tool);
    }

    @Override
    public int toolResultSize() {
        return 64;
    }

    @Override
    public void updateInputs(IToolStackView result, ITinkerableContainer.Mutable inv, ModifierEntry selected, boolean isServer) {
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.modifierSortingSerializer.get();
    }
}

