/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.armor;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ArmorWalkModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class LightspeedArmorModifier
extends Modifier
implements ArmorWalkModifierHook,
EquipmentChangeModifierHook,
TooltipModifierHook {
    private static final UUID ATTRIBUTE_BONUS = UUID.fromString("8790747b-6654-4bd8-83c7-dbe9ae04c0ca");

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.BOOT_WALK, TinkerHooks.EQUIPMENT_CHANGE, TinkerHooks.TOOLTIP);
    }

    @Override
    public void onWalk(IToolStackView tool, ModifierEntry modifier, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        if (tool.isBroken() || !living.m_20096_() || living.f_19853_.f_46443_) {
            return;
        }
        AttributeInstance attribute = living.m_21051_(Attributes.f_22279_);
        if (attribute == null) {
            return;
        }
        if (attribute.m_22111_(ATTRIBUTE_BONUS) != null) {
            attribute.m_22120_(ATTRIBUTE_BONUS);
        }
        Vec3 vecPos = living.m_20182_();
        BlockPos pos = new BlockPos(vecPos.f_82479_, vecPos.f_82480_ + 0.5, vecPos.f_82481_);
        int light = living.f_19853_.m_45517_(LightLayer.BLOCK, pos);
        if (light > 5) {
            int scaledLight = light - 5;
            attribute.m_22118_(new AttributeModifier(ATTRIBUTE_BONUS, "tconstruct.modifier.lightspeed", (double)((float)scaledLight * 0.0015f * modifier.getEffectiveLevel()), AttributeModifier.Operation.ADDITION));
            if (RANDOM.nextFloat() < 0.005f * (float)scaledLight) {
                ToolDamageUtil.damageAnimated(tool, 1, living, EquipmentSlot.FEET);
            }
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        AttributeInstance attribute;
        IToolStackView newTool;
        LivingEntity livingEntity = context.getEntity();
        if (context.getChangedSlot() == EquipmentSlot.FEET && ((newTool = context.getReplacementTool()) == null || newTool.isBroken() || newTool.getModifier(this).getEffectiveLevel() != modifier.getEffectiveLevel()) && (attribute = livingEntity.m_21051_(Attributes.f_22279_)) != null && attribute.m_22111_(ATTRIBUTE_BONUS) != null) {
            attribute.m_22120_(ATTRIBUTE_BONUS);
        }
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        float boost;
        float level = modifier.getEffectiveLevel();
        if (player != null && key == TooltipKey.SHIFT) {
            int light = player.f_19853_.m_45517_(LightLayer.BLOCK, player.m_20183_());
            boost = 0.015f * (float)(light - 5) * level;
        } else {
            boost = 0.15f * level;
        }
        if (boost > 0.0f) {
            TooltipModifierHook.addPercentBoost(this, this.getDisplayName(), boost, tooltip);
        }
    }
}

