/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.skull;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.modifiers.traits.skull.ChrysophiliteModifier;

public class GoldGuardModifier
extends NoLevelsModifier
implements EquipmentChangeModifierHook,
TooltipModifierHook {
    private static final UUID GOLD_GUARD_UUID = UUID.fromString("fbae11f1-b547-47e8-ae0c-f2cf24a46d93");
    private static final TinkerDataCapability.ComputableDataKey<GoldGuardGold> TOTAL_GOLD = TConstruct.createKey("gold_guard", GoldGuardGold::new);

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.EQUIPMENT_CHANGE, TinkerHooks.TOOLTIP);
    }

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        if (context.getChangedSlot() == EquipmentSlot.HEAD) {
            context.getTinkerData().ifPresent(data -> {
                GoldGuardGold gold = data.get(TOTAL_GOLD);
                if (gold == null) {
                    ((GoldGuardGold)data.computeIfAbsent(TOTAL_GOLD)).initialize(context);
                } else {
                    gold.setGold(EquipmentSlot.HEAD, tool.getVolatileData().getBoolean(ModifiableArmorItem.PIGLIN_NEUTRAL), context.getEntity());
                }
            });
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        IToolStackView newTool;
        if (context.getChangedSlot() == EquipmentSlot.HEAD && ((newTool = context.getReplacementTool()) == null || newTool.getModifierLevel(this) == 0)) {
            context.getTinkerData().ifPresent(data -> data.remove(TOTAL_GOLD));
            AttributeInstance instance = context.getEntity().m_21051_(Attributes.f_22276_);
            if (instance != null) {
                instance.m_22120_(GOLD_GUARD_UUID);
            }
        }
    }

    @Override
    public void onEquipmentChange(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context, EquipmentSlot slotType) {
        EquipmentSlot changed = context.getChangedSlot();
        if (slotType == EquipmentSlot.HEAD && changed.m_20743_() == EquipmentSlot.Type.ARMOR) {
            LivingEntity living = context.getEntity();
            boolean hasGold = ChrysophiliteModifier.hasGold(context, changed);
            context.getTinkerData().ifPresent(data -> ((GoldGuardGold)data.computeIfAbsent(TOTAL_GOLD)).setGold(changed, hasGold, living));
        }
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry entry, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        AttributeModifier modifier;
        AttributeInstance instance;
        if (player != null && tooltipKey == TooltipKey.SHIFT && (instance = player.m_21051_(Attributes.f_22276_)) != null && (modifier = instance.m_22111_(GOLD_GUARD_UUID)) != null) {
            tooltip.add((Component)this.applyStyle(Component.m_237113_((String)(Util.BONUS_FORMAT.format(modifier.m_22218_()) + " ")).m_7220_((Component)Component.m_237115_((String)(this.getTranslationKey() + ".health")))));
        }
    }

    private static class GoldGuardGold
    extends ChrysophiliteModifier.TotalGold {
        private GoldGuardGold() {
        }

        private void updateAttribute(LivingEntity living) {
            AttributeInstance instance = living.m_21051_(Attributes.f_22276_);
            if (instance != null) {
                if (instance.m_22111_(GOLD_GUARD_UUID) != null) {
                    instance.m_22120_(GOLD_GUARD_UUID);
                }
                instance.m_22118_(new AttributeModifier(GOLD_GUARD_UUID, "tconstruct.gold_guard", (double)(this.getTotalGold() * 4), AttributeModifier.Operation.ADDITION));
            }
        }

        public void setGold(EquipmentSlot slotType, boolean value, LivingEntity living) {
            if (this.setGold(slotType, value)) {
                this.updateAttribute(living);
            }
        }

        @Override
        public void initialize(EquipmentChangeContext context) {
            super.initialize(context);
            this.updateAttribute(context.getEntity());
        }
    }
}

