/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public class ConductingModifier
extends Modifier
implements ConditionalStatModifierHook,
TooltipModifierHook,
MeleeDamageModifierHook {
    private static final Component ATTACK_DAMAGE = TConstruct.makeTranslation("modifier", "conducting.attack_damage");
    private static final int MAX_BONUS_TICKS = 300;
    private static final float PERCENT_PER_LEVEL = 0.15f;

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, TinkerHooks.CONDITIONAL_STAT, TinkerHooks.TOOLTIP, TinkerHooks.MELEE_DAMAGE);
    }

    @Override
    public int getPriority() {
        return 90;
    }

    private static float getBonus(LivingEntity living, int level) {
        int fire = living.m_20094_();
        if (fire > 0) {
            float bonus = 0.15f * (float)level;
            if (fire < 300) {
                bonus *= (float)fire / 300.0f;
            }
            if (living.m_21023_(MobEffects.f_19607_)) {
                bonus /= 2.0f;
            }
            return bonus;
        }
        return 0.0f;
    }

    @Override
    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        float bonus = ConductingModifier.getBonus(context.getAttacker(), modifier.getLevel());
        if (bonus > 0.0f) {
            damage *= 1.0f + bonus;
        }
        return damage;
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        float bonus;
        if (stat == ToolStats.PROJECTILE_DAMAGE && (bonus = ConductingModifier.getBonus(living, modifier.getLevel())) > 0.0f) {
            baseValue *= 1.0f + bonus;
        }
        return baseValue;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        if (tool.hasTag(TinkerTags.Items.RANGED) || tool.hasTag(TinkerTags.Items.MELEE)) {
            float bonus = 0.15f * (float)modifier.getLevel();
            if (player != null && key == TooltipKey.SHIFT && player.m_20094_() == 0) {
                bonus = 0.0f;
            }
            tooltip.add((Component)this.applyStyle(Component.m_237113_((String)(Util.PERCENT_BOOST_FORMAT.format(bonus) + " ")).m_7220_(ATTACK_DAMAGE)));
        }
    }
}

