/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class MomentumModifier
extends Modifier
implements ProjectileLaunchModifierHook,
ConditionalStatModifierHook,
BlockBreakModifierHook,
BreakSpeedModifierHook,
TooltipModifierHook {
    private static final Component SPEED = TConstruct.makeTranslation("modifier", "momentum.speed");

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, TinkerHooks.CONDITIONAL_STAT, TinkerHooks.PROJECTILE_LAUNCH, TinkerHooks.BLOCK_BREAK, TinkerHooks.BREAK_SPEED, TinkerHooks.TOOLTIP);
    }

    @Override
    public int getPriority() {
        return 75;
    }

    private static float getBonus(LivingEntity living, RegistryObject<? extends TinkerEffect> effect, int level, float scale) {
        int effectLevel = ((TinkerEffect)((Object)effect.get())).getLevel(living) + 1;
        return (float)(level * effectLevel) / scale;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + MomentumModifier.getBonus((LivingEntity)event.getEntity(), TinkerModifiers.momentumEffect, modifier.getLevel(), 128.0f)));
        }
    }

    @Override
    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
        if (context.canHarvest() && context.isEffective() && !context.isAOE()) {
            LivingEntity living = context.getLiving();
            int effectLevel = Math.min(31, ((TinkerEffect)((Object)TinkerModifiers.momentumEffect.get())).getLevel(living) + 1);
            int duration = (int)(10.0f / tool.getStats().get(ToolStats.MINING_SPEED).floatValue() * 1.5f * 20.0f);
            ((TinkerEffect)((Object)TinkerModifiers.momentumEffect.get())).apply(living, duration, effectLevel, true);
        }
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
        if (primary && (arrow == null || arrow.m_36792_())) {
            int effectLevel = Math.min(15, ((TinkerEffect)((Object)TinkerModifiers.momentumRangedEffect.get())).getLevel(shooter) + 1);
            ((TinkerEffect)((Object)TinkerModifiers.momentumRangedEffect.get())).apply(shooter, 100, effectLevel, true);
        }
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.DRAW_SPEED) {
            return baseValue * (1.0f + MomentumModifier.getBonus(living, TinkerModifiers.momentumRangedEffect, modifier.getLevel(), 64.0f));
        }
        return baseValue;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (harvest || tool.hasTag(TinkerTags.Items.RANGED)) {
            int level = modifier.getLevel();
            float bonus = player != null && key == TooltipKey.SHIFT ? (harvest ? MomentumModifier.getBonus((LivingEntity)player, TinkerModifiers.momentumEffect, level, 128.0f) : MomentumModifier.getBonus((LivingEntity)player, TinkerModifiers.momentumRangedEffect, level, 64.0f)) : (float)level * 0.25f;
            if (bonus > 0.0f) {
                TooltipModifierHook.addPercentBoost(this, SPEED, bonus, tooltip);
            }
        }
    }
}

