/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.Util;

public class StatOverrideModifier
extends NoLevelsModifier
implements ToolStatsModifierHook,
ModifierRemovalHook {
    private static final ResourceLocation KEY_BONUS = TConstruct.getResource("override_bonus");
    private static final ResourceLocation KEY_MULTIPLY = TConstruct.getResource("override_multiplier");
    private static final Component LANG_BONUS = TConstruct.makeTranslation("modifier", "stat_override.bonuses").m_130940_(ChatFormatting.UNDERLINE);
    private static final Component LANG_MULTIPLY = TConstruct.makeTranslation("modifier", "stat_override.multipliers").m_130940_(ChatFormatting.UNDERLINE);

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.TOOL_STATS, TinkerHooks.REMOVE);
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return advanced;
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(KEY_BONUS);
        tool.getPersistentData().remove(KEY_MULTIPLY);
        return null;
    }

    private static void processStats(IModDataView persistentData, ResourceLocation key, StatConsumer consumer) {
        if (persistentData.contains(key, 10)) {
            CompoundTag nbt = persistentData.getCompound(key);
            for (String name : nbt.m_128431_()) {
                IToolStat<?> stat;
                ToolStatId id = ToolStatId.tryParse(name);
                if (id == null || (stat = ToolStats.getToolStat(id)) == null) continue;
                consumer.handle(stat, Objects.requireNonNull(nbt.m_128423_(name)));
            }
        }
    }

    private static <T> void update(ModifierStatsBuilder builder, IToolStat<T> stat, Tag tag) {
        T value = stat.read(tag);
        if (value != null) {
            stat.update(builder, value);
        }
    }

    @Override
    public void addToolStats(ToolRebuildContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        IModDataView persistentData = context.getPersistentData();
        StatOverrideModifier.processStats(persistentData, KEY_BONUS, (stat, tag) -> StatOverrideModifier.update(builder, stat, tag));
        StatOverrideModifier.processStats(persistentData, KEY_MULTIPLY, (stat, tag) -> {
            if (stat instanceof INumericToolStat) {
                INumericToolStat numeric = (INumericToolStat)stat;
                if (TagUtil.isNumeric(tag)) {
                    numeric.multiply(builder, ((NumericTag)tag).m_7057_());
                }
            }
        });
    }

    @Nullable
    private static <T> Component format(IToolStat<T> stat, Tag tag) {
        T value = stat.read(tag);
        return value == null ? null : stat.formatValue(value);
    }

    private static void addToTooltip(IModDataView persistentData, ResourceLocation groupKey, Component listStart, DecimalFormat format, Consumer<Component> consumer) {
        if (persistentData.contains(groupKey, 10)) {
            CompoundTag stats = persistentData.getCompound(groupKey);
            boolean first = true;
            for (String key : stats.m_128431_()) {
                IToolStat<?> stat;
                ToolStatId id = ToolStatId.tryParse(key);
                if (id == null || (stat = ToolStats.getToolStat(id)) == null) continue;
                if (first) {
                    consumer.accept(listStart);
                    first = false;
                }
                if (stat instanceof INumericToolStat) {
                    consumer.accept((Component)Component.m_237113_((String)"* ").m_7220_((Component)stat.getPrefix()).m_130946_(format.format(stats.m_128457_(key))));
                    continue;
                }
                Component formatted = StatOverrideModifier.format(stat, Objects.requireNonNull(stats.m_128423_(key)));
                if (formatted == null) continue;
                consumer.accept((Component)Component.m_237113_((String)"* ").m_7220_(formatted));
            }
        }
    }

    @Override
    public List<Component> getDescriptionList(IToolStackView tool, ModifierEntry entry) {
        List<Component> defaultList = this.getDescriptionList(entry.getLevel());
        MutableObject resultList = new MutableObject();
        Consumer<Component> consumer = text -> {
            ArrayList<Component> list = (ArrayList<Component>)resultList.getValue();
            if (list == null) {
                list = new ArrayList<Component>(defaultList);
                resultList.setValue(list);
            }
            list.add((Component)text);
        };
        ModDataNBT persistentData = tool.getPersistentData();
        StatOverrideModifier.addToTooltip(persistentData, KEY_BONUS, LANG_BONUS, Util.BONUS_FORMAT, consumer);
        StatOverrideModifier.addToTooltip(persistentData, KEY_MULTIPLY, LANG_MULTIPLY, Util.MULTIPLIER_FORMAT, consumer);
        List computedList = (List)resultList.getValue();
        if (computedList != null) {
            return computedList;
        }
        return defaultList;
    }

    @Nullable
    private static CompoundTag getTag(IToolStackView tool, ResourceLocation groupKey, boolean createTag) {
        ModDataNBT data = tool.getPersistentData();
        if (data.contains(groupKey, 10)) {
            return data.getCompound(groupKey);
        }
        if (createTag) {
            CompoundTag nbt = new CompoundTag();
            data.put(groupKey, (Tag)nbt);
            return nbt;
        }
        return null;
    }

    private static float getStat(IToolStackView tool, ResourceLocation groupKey, INumericToolStat<?> stat, float defaultValue) {
        String name;
        CompoundTag nbt;
        ModDataNBT data = tool.getPersistentData();
        if (data.contains(groupKey, 10) && (nbt = data.getCompound(groupKey)).m_128425_(name = stat.getName().toString(), 5)) {
            return nbt.m_128457_(name);
        }
        return defaultValue;
    }

    private static boolean setStat(IToolStackView tool, ResourceLocation groupKey, INumericToolStat<?> stat, float value, float neutralValue) {
        CompoundTag nbt = StatOverrideModifier.getTag(tool, groupKey, value != neutralValue);
        if (nbt == null) {
            return false;
        }
        String name = stat.getName().toString();
        if (value != neutralValue) {
            nbt.m_128350_(name, value);
            return true;
        }
        nbt.m_128473_(name);
        if (nbt.m_128431_().isEmpty()) {
            tool.getPersistentData().remove(groupKey);
            return false;
        }
        return true;
    }

    public <T> boolean set(IToolStackView tool, IToolStat<T> stat, T value) {
        Tag tag;
        ModDataNBT data = tool.getPersistentData();
        boolean storeValue = stat instanceof INumericToolStat ? ((Number)value).intValue() != 0 : value != stat.getDefaultValue();
        CompoundTag nbt = StatOverrideModifier.getTag(tool, KEY_BONUS, storeValue);
        if (nbt == null) {
            return false;
        }
        String name = stat.getName().toString();
        if (storeValue && (tag = stat.write(value)) != null) {
            nbt.m_128365_(name, tag);
            return true;
        }
        nbt.m_128473_(name);
        if (nbt.m_128431_().isEmpty()) {
            data.remove(KEY_BONUS);
            return false;
        }
        return true;
    }

    public boolean addBonus(IToolStackView tool, INumericToolStat<?> stat, float bonus) {
        if (bonus != 0.0f) {
            return StatOverrideModifier.setStat(tool, KEY_BONUS, stat, StatOverrideModifier.getStat(tool, KEY_BONUS, stat, 0.0f) + bonus, 0.0f);
        }
        return false;
    }

    public boolean setMultiplier(IToolStackView tool, INumericToolStat<?> stat, float multiplier) {
        return StatOverrideModifier.setStat(tool, KEY_MULTIPLY, stat, multiplier, 1.0f);
    }

    public boolean multiply(IToolStackView tool, INumericToolStat<?> stat, float value) {
        if (value != 1.0f) {
            return this.setMultiplier(tool, stat, StatOverrideModifier.getStat(tool, KEY_MULTIPLY, stat, 1.0f) * value);
        }
        return false;
    }

    public <T> boolean remove(IToolStackView tool, IToolStat<T> stat) {
        CompoundTag nbt = StatOverrideModifier.getTag(tool, KEY_BONUS, false);
        if (nbt == null) {
            return false;
        }
        nbt.m_128473_(stat.getName().toString());
        if (nbt.m_128431_().isEmpty()) {
            tool.getPersistentData().remove(KEY_BONUS);
            return false;
        }
        return true;
    }

    @FunctionalInterface
    private static interface StatConsumer {
        public void handle(IToolStat<?> var1, Tag var2);
    }
}

