/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.data.FloatMultiplier;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class FarsightedModifier
extends Modifier
implements EquipmentChangeModifierHook {
    private final ResourceLocation[] SLOT_KEYS = (ResourceLocation[])Arrays.stream(EquipmentSlot.values()).sorted(Comparator.comparing(EquipmentSlot::m_20750_)).map(slot -> TConstruct.getResource("farsighted_" + slot.m_20751_())).toArray(ResourceLocation[]::new);

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.EQUIPMENT_CHANGE);
    }

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        if (!tool.isBroken()) {
            ResourceLocation key = this.SLOT_KEYS[context.getChangedSlot().m_20750_()];
            context.getTinkerData().ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).set(key, 1.0f / (1.0f + 0.05f * (float)modifier.getLevel())));
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        if (!tool.isBroken()) {
            ResourceLocation key = this.SLOT_KEYS[context.getChangedSlot().m_20750_()];
            context.getTinkerData().ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).remove(key));
        }
    }
}

