/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class CreativeSlotModifier
extends NoLevelsModifier
implements VolatileDataModifierHook,
ModifierRemovalHook {
    public static final ResourceLocation KEY_SLOTS = TConstruct.getResource("creative");

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.VOLATILE_DATA, TinkerHooks.REMOVE);
    }

    @Override
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(KEY_SLOTS);
        return null;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        IModDataView persistentData = context.getPersistentData();
        if (persistentData.contains(KEY_SLOTS, 10)) {
            CompoundTag slots = persistentData.getCompound(KEY_SLOTS);
            for (String key : slots.m_128431_()) {
                SlotType slotType = SlotType.getIfPresent(key);
                if (slotType == null) continue;
                volatileData.addSlots(slotType, slots.m_128451_(key));
            }
        }
    }

    private static Component formatCount(SlotType slotType, int count) {
        return Component.m_237113_((String)((count > 0 ? "+" : "") + count + " ")).m_7220_(slotType.getDisplayName()).m_130938_(style -> style.m_131148_(slotType.getColor()));
    }

    @Override
    public List<Component> getDescriptionList(IToolStackView tool, ModifierEntry entry) {
        List<Component> tooltip = this.getDescriptionList(entry.getLevel());
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(KEY_SLOTS, 10)) {
            CompoundTag slots = persistentData.getCompound(KEY_SLOTS);
            boolean first = true;
            for (String key : slots.m_128431_()) {
                SlotType slotType = SlotType.getIfPresent(key);
                if (slotType == null) continue;
                if (first) {
                    tooltip = new ArrayList<Component>(tooltip);
                    first = false;
                }
                tooltip.add(CreativeSlotModifier.formatCount(slotType, slots.m_128451_(key)));
            }
        }
        return tooltip;
    }
}

