/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.armor.ProtectionModule;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class MeleeProtectionModifier
extends AbstractProtectionModifier<ModifierMaxLevel>
implements ProtectionModifierHook,
TooltipModifierHook {
    private static final UUID SPEED_UUID = UUID.fromString("6f030b1e-e9e1-11ec-8fea-0242ac120002");
    private static final TinkerDataCapability.TinkerDataKey<ModifierMaxLevel> KEY = TConstruct.createKey("melee_protection");

    public MeleeProtectionModifier() {
        super(KEY);
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.PROTECTION, TinkerHooks.TOOLTIP);
    }

    @Override
    protected void set(ModifierMaxLevel data, EquipmentSlot slot, float scaledLevel, EquipmentChangeContext context) {
        AttributeInstance instance;
        float oldMax = data.getMax();
        super.set(data, slot, scaledLevel, context);
        float newMax = data.getMax();
        if (oldMax != newMax && (instance = context.getEntity().m_21051_(Attributes.f_22283_)) != null) {
            instance.m_22120_(SPEED_UUID);
            if (newMax != 0.0f) {
                instance.m_22118_(new AttributeModifier(SPEED_UUID, "tconstruct.melee_protection", 0.03 * (double)newMax, AttributeModifier.Operation.MULTIPLY_BASE));
            }
        }
    }

    @Override
    protected void reset(ModifierMaxLevel data, EquipmentChangeContext context) {
        super.reset(data, context);
        AttributeInstance instance = context.getEntity().m_21051_(Attributes.f_22283_);
        if (instance != null) {
            instance.m_22120_(SPEED_UUID);
        }
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        if (DamageSourcePredicate.CAN_PROTECT.matches((Object)source) && DamageSourcePredicate.MELEE.matches((Object)source)) {
            modifierValue = (float)((double)modifierValue + (double)modifier.getEffectiveLevel() * 2.5);
        }
        return modifierValue;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ProtectionModule.addResistanceTooltip(tool, this, modifier.getEffectiveLevel() * 2.5f, player, tooltip);
    }

    @Override
    protected ModifierMaxLevel createData(EquipmentChangeContext context) {
        return new ModifierMaxLevel();
    }
}

