/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.armor.ProtectionModule;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class MagicProtectionModifier
extends AbstractProtectionModifier<ModifierMaxLevel>
implements ProtectionModifierHook,
TooltipModifierHook {
    private static final TinkerDataCapability.TinkerDataKey<ModifierMaxLevel> MAGIC_DATA = TConstruct.createKey("magic_protection");

    public MagicProtectionModifier() {
        super(MAGIC_DATA);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, MobEffectEvent.Added.class, MagicProtectionModifier::onPotionStart);
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.PROTECTION, TinkerHooks.TOOLTIP);
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        if (!source.m_19379_() && !source.m_19378_() && source.m_19387_()) {
            modifierValue += modifier.getEffectiveLevel() * 2.5f;
        }
        return modifierValue;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ProtectionModule.addResistanceTooltip(tool, this, modifier.getEffectiveLevel() * 2.5f, player, tooltip);
    }

    @Override
    protected ModifierMaxLevel createData(EquipmentChangeContext context) {
        return new ModifierMaxLevel();
    }

    private static void onPotionStart(MobEffectEvent.Added event) {
        MobEffectInstance newEffect = event.getEffectInstance();
        if (!newEffect.m_19544_().m_19486_() && !newEffect.getCurativeItems().isEmpty()) {
            LivingEntity living = event.getEntity();
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                float max;
                ModifierMaxLevel magicData = data.get(MAGIC_DATA);
                if (magicData != null && (max = magicData.getMax()) > 0.0f) {
                    int duration = (int)((float)newEffect.m_19557_() * (1.0f - max * 0.05f));
                    if (duration < 0) {
                        duration = 0;
                    }
                    newEffect.f_19503_ = duration;
                }
            });
        }
    }
}

