/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.armor.ProtectionModule;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class DragonbornModifier
extends AbstractProtectionModifier<ModifierMaxLevel>
implements ProtectionModifierHook,
TooltipModifierHook {
    private static final TinkerDataCapability.TinkerDataKey<ModifierMaxLevel> DRAGONBORN = TConstruct.createKey("dragonborn");

    public DragonbornModifier() {
        super(DRAGONBORN);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, CriticalHitEvent.class, DragonbornModifier::onCritical);
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.PROTECTION, TinkerHooks.TOOLTIP);
    }

    @Override
    protected ModifierMaxLevel createData(EquipmentChangeContext context) {
        return new ModifierMaxLevel();
    }

    private static boolean isAirborne(LivingEntity living) {
        return TinkerPredicate.AIRBORNE.matches((Object)living);
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        if (!source.m_19379_() && !source.m_19378_() && DragonbornModifier.isAirborne(context.getEntity())) {
            modifierValue += modifier.getEffectiveLevel() * 2.5f;
        }
        return modifierValue;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ProtectionModule.addResistanceTooltip(tool, this, modifier.getEffectiveLevel() * 2.5f, player, tooltip);
    }

    private static void onCritical(CriticalHitEvent event) {
        if (event.getResult() != Event.Result.DENY) {
            Player living = event.getEntity();
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(arg_0 -> DragonbornModifier.lambda$onCritical$0(event, (LivingEntity)living, arg_0));
        }
    }

    private static /* synthetic */ void lambda$onCritical$0(CriticalHitEvent event, LivingEntity living, TinkerDataCapability.Holder data) {
        float max;
        ModifierMaxLevel dragonborn = data.get(DRAGONBORN);
        if (dragonborn != null && (max = dragonborn.getMax()) > 0.0f) {
            boolean isCritical;
            boolean bl = isCritical = event.isVanillaCritical() || event.getResult() == Event.Result.ALLOW;
            if (!isCritical && DragonbornModifier.isAirborne(living)) {
                isCritical = true;
                event.setResult(Event.Result.ALLOW);
            }
            if (isCritical) {
                event.setDamageModifier(event.getDamageModifier() + max * 0.05f);
            }
        }
    }
}

