/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.tool;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.fluid.FluidTransferHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.modules.behavior.ShowOffhandModule;
import slimeknights.tconstruct.library.modifiers.modules.fluid.TankModule;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.definition.module.ToolModuleHooks;
import slimeknights.tconstruct.library.tools.definition.module.interaction.DualOptionInteraction;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class BucketingModifier
extends Modifier
implements BlockInteractionModifierHook,
GeneralInteractionModifierHook,
EquipmentChangeModifierHook {
    private TankModule tank;

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        this.tank = new TankModule(1000, false);
        hookBuilder.addModule(this.tank);
        hookBuilder.addHook(this, TinkerHooks.BLOCK_INTERACT, TinkerHooks.GENERAL_INTERACT);
        hookBuilder.addModule(ShowOffhandModule.ALLOW_BROKEN);
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry) {
        return DualOptionInteraction.formatModifierName(tool, this, super.getDisplayName(tool, entry));
    }

    private static boolean cannotContainFluid(Level world, BlockPos pos, BlockState state, Fluid fluid) {
        LiquidBlockContainer container;
        Block block = state.m_60734_();
        return !state.m_60722_(fluid) && (!(block instanceof LiquidBlockContainer) || !(container = (LiquidBlockContainer)block).m_6044_((BlockGetter)world, pos, state, fluid));
    }

    @Override
    public InteractionResult beforeBlockUse(IToolStackView tool, ModifierEntry modifier, UseOnContext context, InteractionSource source) {
        BlockPos target;
        if (source != InteractionSource.ARMOR) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        BlockEntity te = world.m_7702_(target = context.m_8083_());
        if (te == null) {
            return InteractionResult.PASS;
        }
        Direction face = context.m_43719_();
        LazyOptional capability = te.getCapability(ForgeCapabilities.FLUID_HANDLER, face);
        if (!capability.isPresent()) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            Player player = context.m_43723_();
            boolean sneaking = player != null && player.m_6144_();
            capability.ifPresent(cap -> {
                FluidStack fluidStack = this.tank.getFluid(tool);
                SoundEvent sound = null;
                if (sneaking) {
                    int added;
                    if (!fluidStack.isEmpty() && (added = cap.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                        sound = FluidTransferHelper.getEmptySound((FluidStack)fluidStack);
                        fluidStack.shrink(added);
                        this.tank.setFluid(tool, fluidStack);
                    }
                } else if (fluidStack.isEmpty()) {
                    FluidStack drained = cap.drain(this.tank.getCapacity(tool), IFluidHandler.FluidAction.EXECUTE);
                    if (!drained.isEmpty()) {
                        this.tank.setFluid(tool, drained);
                        sound = FluidTransferHelper.getFillSound((FluidStack)fluidStack);
                    }
                } else {
                    FluidStack drained = cap.drain(new FluidStack(fluidStack, this.tank.getCapacity(tool) - fluidStack.getAmount()), IFluidHandler.FluidAction.EXECUTE);
                    if (!drained.isEmpty() && drained.isFluidEqual(fluidStack)) {
                        fluidStack.grow(drained.getAmount());
                        this.tank.setFluid(tool, fluidStack);
                        sound = FluidTransferHelper.getFillSound((FluidStack)fluidStack);
                    }
                }
                if (sound != null) {
                    world.m_5594_(null, target, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            });
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    @Override
    public InteractionResult afterBlockUse(IToolStackView tool, ModifierEntry modifier, UseOnContext context, InteractionSource source) {
        if (!tool.getDefinitionData().getModule(ToolModuleHooks.INTERACTION).canInteract(tool, modifier.getId(), source)) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player == null || !player.m_6144_()) {
            return InteractionResult.PASS;
        }
        FluidStack fluidStack = this.tank.getFluid(tool);
        if (fluidStack.getAmount() < 1000) {
            return InteractionResult.PASS;
        }
        Fluid fluid = fluidStack.getFluid();
        if (!(fluid instanceof FlowingFluid)) {
            return InteractionResult.PASS;
        }
        Direction face = context.m_43719_();
        Level world = context.m_43725_();
        BlockPos target = context.m_8083_();
        BlockPos offset = target.m_121945_(face);
        if (!world.m_7966_(player, target) || !player.m_36204_(offset, face, context.m_43722_())) {
            return InteractionResult.PASS;
        }
        BlockState existing = world.m_8055_(target);
        if (BucketingModifier.cannotContainFluid(world, target, existing, fluidStack.getFluid()) && BucketingModifier.cannotContainFluid(world, target = offset, existing = world.m_8055_(target), fluidStack.getFluid())) {
            return InteractionResult.PASS;
        }
        boolean placed = false;
        if (world.m_6042_().f_63857_() && fluid.m_205067_(FluidTags.f_13131_)) {
            world.m_5594_(player, target, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)target.m_123341_() + Math.random(), (double)target.m_123342_() + Math.random(), (double)target.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
            }
            placed = true;
        } else if (existing.m_60722_(fluid)) {
            if (!world.f_46443_ && !existing.m_60767_().m_76332_()) {
                world.m_46961_(target, true);
            }
            if (world.m_46597_(target, fluid.m_76145_().m_76188_()) || existing.m_60819_().m_76170_()) {
                world.m_5594_(null, target, FluidTransferHelper.getEmptySound((FluidStack)fluidStack), SoundSource.BLOCKS, 1.0f, 1.0f);
                placed = true;
            }
        } else {
            Block block = existing.m_60734_();
            if (block instanceof LiquidBlockContainer) {
                LiquidBlockContainer container = (LiquidBlockContainer)block;
                container.m_7361_((LevelAccessor)world, target, existing, ((FlowingFluid)fluid).m_76068_(false));
                world.m_5594_(null, target, FluidTransferHelper.getEmptySound((FluidStack)fluidStack), SoundSource.BLOCKS, 1.0f, 1.0f);
                placed = true;
            }
        }
        if (placed) {
            fluidStack.shrink(1000);
            this.tank.setFluid(tool, fluidStack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        BucketItem bucketItem;
        Fluid pickedUpFluid;
        Item item;
        BucketPickup bucketPickup;
        ItemStack bucket;
        if (player.m_6047_() || !tool.getDefinitionData().getModule(ToolModuleHooks.INTERACTION).canInteract(tool, modifier.getId(), source)) {
            return InteractionResult.PASS;
        }
        FluidStack fluidStack = this.tank.getFluid(tool);
        if (this.tank.getCapacity(tool) - fluidStack.getAmount() < 1000) {
            return InteractionResult.PASS;
        }
        Level world = player.f_19853_;
        BlockHitResult trace = ModifiableItem.blockRayTrace(world, player, ClipContext.Fluid.SOURCE_ONLY);
        if (trace.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        Direction face = trace.m_82434_();
        BlockPos target = trace.m_82425_();
        BlockPos offset = target.m_121945_(face);
        if (!world.m_7966_(player, target) || !player.m_36204_(offset, face, player.m_6844_(source.getSlot(hand)))) {
            return InteractionResult.PASS;
        }
        FluidState fluidState = world.m_6425_(target);
        Fluid currentFluid = fluidStack.getFluid();
        if (fluidState.m_76178_() || !fluidStack.isEmpty() && !currentFluid.m_6212_(fluidState.m_76152_())) {
            return InteractionResult.PASS;
        }
        BlockState state = world.m_8055_(target);
        Block block = state.m_60734_();
        if (block instanceof BucketPickup && !(bucket = (bucketPickup = (BucketPickup)block).m_142598_((LevelAccessor)world, target, state)).m_41619_() && (item = bucket.m_41720_()) instanceof BucketItem && (pickedUpFluid = (bucketItem = (BucketItem)item).getFluid()) != Fluids.f_76191_) {
            player.m_5496_(Objects.requireNonNullElse(pickedUpFluid.getFluidType().getSound(SoundActions.BUCKET_FILL), SoundEvents.f_11781_), 1.0f, 1.0f);
            if (!world.f_46443_) {
                if (fluidStack.isEmpty()) {
                    this.tank.setFluid(tool, new FluidStack(pickedUpFluid, 1000));
                } else if (pickedUpFluid == currentFluid) {
                    fluidStack.grow(1000);
                    this.tank.setFluid(tool, fluidStack);
                } else {
                    TConstruct.LOG.error("Picked up a fluid {} that does not match the current fluid state {}, this should not happen", (Object)pickedUpFluid, (Object)fluidState.m_76152_());
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

