/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ToolRenderEvents {
    private static final int MAX_BLOCKS = 60;

    @SubscribeEvent
    static void renderBlockHighlights(RenderHighlightEvent.Block event) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (world == null || player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_() || !stack.m_204117_(TinkerTags.Items.HARVEST)) {
            return;
        }
        HitResult result = Minecraft.m_91087_().f_91077_;
        if (result == null || result.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return;
        }
        BlockHitResult blockTrace = event.getTarget();
        BlockPos origin = blockTrace.m_82425_();
        BlockState state = world.m_8055_(origin);
        if (!ToolHarvestLogic.isEffective(tool, state)) {
            return;
        }
        Iterator<BlockPos> extraBlocks = tool.getDefinition().getData().getAOE().getBlocks(tool, stack, (Player)player, world.m_8055_(origin), (Level)world, origin, blockTrace.m_82434_(), IAreaOfEffectIterator.AOEMatchType.BREAKING).iterator();
        if (!extraBlocks.hasNext()) {
            return;
        }
        LevelRenderer worldRender = event.getLevelRenderer();
        PoseStack matrices = event.getPoseStack();
        MultiBufferSource.BufferSource buffers = worldRender.f_109464_.m_110104_();
        VertexConsumer vertexBuilder = buffers.m_6299_(RenderType.m_110504_());
        matrices.m_85836_();
        Camera renderInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        Entity viewEntity = renderInfo.m_90592_();
        Vec3 vector3d = renderInfo.m_90583_();
        double x = vector3d.m_7096_();
        double y = vector3d.m_7098_();
        double z = vector3d.m_7094_();
        int rendered = 0;
        do {
            BlockPos pos = extraBlocks.next();
            if (!world.m_6857_().m_61937_(pos)) continue;
            ++rendered;
            worldRender.m_109637_(matrices, vertexBuilder, viewEntity, x, y, z, pos, world.m_8055_(pos));
        } while (rendered < 60 && extraBlocks.hasNext());
        matrices.m_85849_();
        buffers.m_109911_();
    }

    @SubscribeEvent
    static void renderBlockDamageProgress(RenderLevelLastEvent event) {
        MultiPlayerGameMode controller = Minecraft.m_91087_().f_91072_;
        if (controller == null || !controller.m_105296_()) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (world == null || player == null || Minecraft.m_91087_().m_91288_() == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_() || !stack.m_204117_(TinkerTags.Items.HARVEST)) {
            return;
        }
        HitResult result = Minecraft.m_91087_().f_91077_;
        if (result == null || result.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return;
        }
        BlockHitResult blockTrace = (BlockHitResult)result;
        BlockPos target = blockTrace.m_82425_();
        BlockDestructionProgress progress = null;
        for (Int2ObjectMap.Entry entry : Minecraft.m_91087_().f_91060_.f_109408_.int2ObjectEntrySet()) {
            if (!((BlockDestructionProgress)entry.getValue()).m_139985_().equals((Object)target)) continue;
            progress = (BlockDestructionProgress)entry.getValue();
            break;
        }
        if (progress == null) {
            return;
        }
        BlockState state = world.m_8055_(target);
        if (!ToolHarvestLogic.isEffective(tool, state)) {
            return;
        }
        Iterator<BlockPos> extraBlocks = tool.getDefinition().getData().getAOE().getBlocks(tool, stack, (Player)player, state, (Level)world, target, blockTrace.m_82434_(), IAreaOfEffectIterator.AOEMatchType.BREAKING).iterator();
        if (!extraBlocks.hasNext()) {
            return;
        }
        PoseStack matrices = event.getPoseStack();
        matrices.m_85836_();
        MultiBufferSource.BufferSource vertices = event.getLevelRenderer().f_109464_.m_110108_();
        VertexConsumer vertexBuilder = vertices.m_6299_((RenderType)ModelBakery.f_119229_.get(progress.m_139988_()));
        Camera renderInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        double x = renderInfo.m_90583_().f_82479_;
        double y = renderInfo.m_90583_().f_82480_;
        double z = renderInfo.m_90583_().f_82481_;
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        int rendered = 0;
        do {
            BlockPos pos = extraBlocks.next();
            matrices.m_85836_();
            matrices.m_85837_((double)pos.m_123341_() - x, (double)pos.m_123342_() - y, (double)pos.m_123343_() - z);
            PoseStack.Pose entry = matrices.m_85850_();
            SheetedDecalTextureGenerator blockBuilder = new SheetedDecalTextureGenerator(vertexBuilder, entry.m_85861_(), entry.m_85864_());
            dispatcher.m_110918_(world.m_8055_(pos), pos, (BlockAndTintGetter)world, matrices, (VertexConsumer)blockBuilder);
            matrices.m_85849_();
        } while (++rendered < 60 && extraBlocks.hasNext());
        matrices.m_85849_();
        vertices.m_109911_();
    }
}

