/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.particle;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.Codec;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidParticleData
implements ParticleOptions {
    private static final DynamicCommandExceptionType UNKNOWN_FLUID = new DynamicCommandExceptionType(arg -> Component.m_237110_((String)"command.tconstruct.fluid.not_found", (Object[])new Object[]{arg}));
    private static final ParticleOptions.Deserializer<FluidParticleData> DESERIALIZER = new ParticleOptions.Deserializer<FluidParticleData>(){

        public FluidParticleData fromCommand(ParticleType<FluidParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int i = reader.getCursor();
            ResourceLocation id = ResourceLocation.m_135818_((StringReader)reader);
            Fluid fluid = (Fluid)Registry.f_122822_.m_6612_(id).orElseThrow(() -> {
                reader.setCursor(i);
                return UNKNOWN_FLUID.createWithContext((ImmutableStringReader)reader, (Object)id.toString());
            });
            CompoundTag nbt = null;
            if (reader.canRead() && reader.peek() == '{') {
                nbt = new TagParser(reader).m_129373_();
            }
            return new FluidParticleData(type, new FluidStack(fluid, 1000, nbt));
        }

        public FluidParticleData fromNetwork(ParticleType<FluidParticleData> type, FriendlyByteBuf buffer) {
            return new FluidParticleData(type, FluidStack.readFromPacket((FriendlyByteBuf)buffer));
        }
    };
    private final ParticleType<FluidParticleData> type;
    private final FluidStack fluid;

    public void m_7711_(FriendlyByteBuf buffer) {
        this.fluid.writeToPacket(buffer);
    }

    public String m_5942_() {
        StringBuilder builder = new StringBuilder();
        builder.append(Registry.f_122829_.m_7981_(this.m_6012_()));
        builder.append(" ");
        builder.append(Registry.f_122822_.m_7981_((Object)this.fluid.getFluid()));
        CompoundTag nbt = this.fluid.getTag();
        if (nbt != null) {
            builder.append(nbt);
        }
        return builder.toString();
    }

    public FluidParticleData(ParticleType<FluidParticleData> type, FluidStack fluid) {
        this.type = type;
        this.fluid = fluid;
    }

    public ParticleType<FluidParticleData> m_6012_() {
        return this.type;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public static class Type
    extends ParticleType<FluidParticleData> {
        public Type() {
            super(false, DESERIALIZER);
        }

        public Codec<FluidParticleData> m_7652_() {
            return FluidStack.CODEC.xmap(fluid -> new FluidParticleData(this, (FluidStack)fluid), data -> data.fluid);
        }
    }
}

