/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.partbuilder;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.recipe.partbuilder.IDisplayPartBuilderRecipe;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.partbuilder.MaterialItemList;
import slimeknights.tconstruct.tables.TinkerTables;

public class PartBuilderCategory
implements IRecipeCategory<IDisplayPartBuilderRecipe> {
    private static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/tinker_station.png");
    private static final Component TITLE = TConstruct.makeTranslation("jei", "part_builder.title");
    private static final String KEY_COST = TConstruct.makeTranslationKey("jei", "part_builder.cost");
    private final IDrawable background;
    private final IDrawable icon;

    public PartBuilderCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 117, 121, 46);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(TinkerTables.partBuilder));
    }

    public RecipeType<IDisplayPartBuilderRecipe> getRecipeType() {
        return TConstructJEIConstants.PART_BUILDER;
    }

    public Component getTitle() {
        return TITLE;
    }

    public void draw(IDisplayPartBuilderRecipe recipe, IRecipeSlotsView slots, PoseStack matrixStack, double mouseX, double mouseY) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        Component name = MaterialTooltipCache.getColoredDisplayName(recipe.getMaterial().getVariant());
        fontRenderer.m_92750_(matrixStack, name.getString(), 3.0f, 2.0f, Objects.requireNonNullElse(name.m_7383_().m_131135_(), ResourceColorManager.WHITE).m_131265_());
        String coolingString = I18n.m_118938_((String)KEY_COST, (Object[])new Object[]{recipe.getCost()});
        fontRenderer.m_92883_(matrixStack, coolingString, 3.0f, 35.0f, Color.GRAY.getRGB());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IDisplayPartBuilderRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 25, 16).addItemStacks(MaterialItemList.getItems(recipe.getMaterial().getVariant()));
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 16).addItemStacks(recipe.getPatternItems());
        builder.addSlot(RecipeIngredientRole.INPUT, 46, 16).addIngredient(TConstructJEIConstants.PATTERN_TYPE, (Object)recipe.getPattern());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 15).addItemStack(recipe.m_8043_());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

