/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.Util;

public class MaxToolStat
implements IToolStat<Integer> {
    private final ToolStatId name;
    private final int defaultValue;
    private final IntFunction<Component> displayName;
    @Nullable
    private final TagKey<Item> tag;

    public MaxToolStat(ToolStatId name, int defaultValue, IntFunction<Component> displayName) {
        this(name, defaultValue, displayName, null);
    }

    @Override
    public boolean supports(Item item) {
        return this.tag == null || RegistryHelper.contains(this.tag, (Item)item);
    }

    @Override
    public Integer getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Integer clamp(Integer value) {
        return Mth.m_14045_((int)value, (int)0, (int)Integer.MAX_VALUE);
    }

    @Override
    public TierBuilder makeBuilder() {
        return new TierBuilder();
    }

    @Override
    public void update(ModifierStatsBuilder builder, Integer value) {
        builder.updateStat(this, b -> {
            b.tier = Math.max(b.tier, value);
        });
    }

    @Override
    public Integer build(Object builder, Integer value) {
        return Math.max(value, ((TierBuilder)builder).tier);
    }

    @Override
    @Nullable
    public Integer read(Tag tag) {
        if (TagUtil.isNumeric(tag)) {
            return ((NumericTag)tag).m_7047_();
        }
        return null;
    }

    @Override
    @Nullable
    public Tag write(Integer value) {
        return IntTag.m_128679_((int)value);
    }

    @Override
    public Integer deserialize(JsonElement json) {
        return GsonHelper.m_13897_((JsonElement)json, (String)this.getName().toString());
    }

    @Override
    public JsonElement serialize(Integer value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    public Integer fromNetwork(FriendlyByteBuf buffer) {
        return buffer.m_130242_();
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer, Integer value) {
        buffer.m_130130_(value.intValue());
    }

    @Override
    public Component formatValue(Integer number) {
        return Component.m_237115_((String)Util.makeTranslationKey("tool_stat", this.getName())).m_7220_(this.displayName.apply(number));
    }

    public String toString() {
        return "TierToolStat{" + this.name + "}";
    }

    public MaxToolStat(ToolStatId name, int defaultValue, IntFunction<Component> displayName, @Nullable TagKey<Item> tag) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.displayName = displayName;
        this.tag = tag;
    }

    @Override
    public ToolStatId getName() {
        return this.name;
    }

    protected static class TierBuilder {
        private int tier = 0;

        protected TierBuilder() {
        }
    }
}

