/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.layout;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.layout.LayoutIcon;
import slimeknights.tconstruct.library.tools.layout.LayoutSlot;

public class StationSlotLayout {
    private static final ResourceLocation EMPTY_NAME = TConstruct.getResource("empty");
    public static final StationSlotLayout EMPTY = new StationSlotLayout("", LayoutIcon.EMPTY, null, LayoutSlot.EMPTY, Collections.emptyList());
    private transient ResourceLocation name = EMPTY_NAME;
    private final String translation_key;
    private final LayoutIcon icon;
    @Nullable
    private final Integer sortIndex;
    private final LayoutSlot tool_slot;
    private final List<LayoutSlot> input_slots;
    private transient Component displayName = null;
    private transient Component description = null;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isMain() {
        return this.sortIndex == null;
    }

    public int getSortIndex() {
        return Objects.requireNonNullElse(this.sortIndex, 255);
    }

    public LayoutIcon getIcon() {
        return Objects.requireNonNullElse(this.icon, LayoutIcon.EMPTY);
    }

    public LayoutSlot getToolSlot() {
        return Objects.requireNonNullElse(this.tool_slot, LayoutSlot.EMPTY);
    }

    public List<LayoutSlot> getInputSlots() {
        return Objects.requireNonNullElse(this.input_slots, Collections.emptyList());
    }

    public int getInputCount() {
        return this.getInputSlots().size();
    }

    public LayoutSlot getSlot(int index) {
        if (index == 0) {
            return this.getToolSlot();
        }
        List<LayoutSlot> inputs = this.getInputSlots();
        if (index < 0 || index > inputs.size()) {
            return LayoutSlot.EMPTY;
        }
        return inputs.get(index - 1);
    }

    public static StationSlotLayout read(FriendlyByteBuf buffer) {
        ResourceLocation name = buffer.m_130281_();
        String translationKey = buffer.m_130136_(Short.MAX_VALUE);
        LayoutIcon icon = LayoutIcon.read(buffer);
        Integer sortIndex = null;
        if (buffer.readBoolean()) {
            sortIndex = buffer.m_130242_();
        }
        LayoutSlot toolSlot = LayoutSlot.read(buffer);
        int max = buffer.m_130242_();
        ImmutableList.Builder inputs = ImmutableList.builder();
        for (int i = 0; i < max; ++i) {
            inputs.add((Object)LayoutSlot.read(buffer));
        }
        StationSlotLayout layout = new StationSlotLayout(translationKey, icon, sortIndex, toolSlot, (List<LayoutSlot>)inputs.build());
        layout.setName(name);
        return layout;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.name);
        buffer.m_130070_(this.getTranslationKey());
        this.icon.write(buffer);
        if (this.sortIndex != null) {
            buffer.writeBoolean(true);
            buffer.m_130130_(this.sortIndex.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        this.getToolSlot().write(buffer);
        List<LayoutSlot> inputs = this.getInputSlots();
        buffer.m_130130_(inputs.size());
        for (LayoutSlot slot : inputs) {
            slot.write(buffer);
        }
    }

    public String getTranslationKey() {
        return Objects.requireNonNullElse(this.translation_key, "");
    }

    public Component getDisplayName() {
        if (this.displayName == null) {
            this.displayName = Component.m_237115_((String)this.getTranslationKey());
        }
        return this.displayName;
    }

    public Component getDescription() {
        if (this.description == null) {
            this.description = Component.m_237115_((String)(this.getTranslationKey() + ".description"));
        }
        return this.description;
    }

    protected StationSlotLayout(String translation_key, LayoutIcon icon, @Nullable Integer sortIndex, LayoutSlot tool_slot, List<LayoutSlot> input_slots) {
        this.translation_key = translation_key;
        this.icon = icon;
        this.sortIndex = sortIndex;
        this.tool_slot = tool_slot;
        this.input_slots = input_slots;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    protected void setName(ResourceLocation name) {
        this.name = name;
    }

    public static class Builder {
        private static final Pattern PICKAXE = new Pattern("tconstruct", "pickaxe");
        private String translationKey = null;
        private LayoutIcon icon = LayoutIcon.EMPTY;
        private Integer sortIndex = null;
        private LayoutSlot toolSlot = null;
        private final ImmutableList.Builder<LayoutSlot> inputSlots = ImmutableList.builder();

        private Builder() {
        }

        public Builder sortIndex(int index) {
            this.sortIndex = index;
            return this;
        }

        public Builder item(ItemStack stack) {
            this.icon(stack);
            this.translationKey = stack.m_41778_();
            return this;
        }

        public Builder icon(ItemStack stack) {
            this.icon = LayoutIcon.ofItem(stack);
            return this;
        }

        public Builder icon(Pattern pattern) {
            this.icon = LayoutIcon.ofPattern(pattern);
            return this;
        }

        public Builder toolSlot(Pattern icon, @Nullable String name, int x, int y, @Nullable Ingredient filter) {
            this.toolSlot = new LayoutSlot(icon, name, x, y, filter);
            return this;
        }

        public Builder toolSlot(int x, int y, @Nullable Ingredient filter) {
            return this.toolSlot(PICKAXE, null, x, y, filter);
        }

        public Builder toolSlot(int x, int y) {
            return this.toolSlot(x, y, null);
        }

        public Builder addInputSlot(@Nullable Pattern icon, @Nullable String name, int x, int y, @Nullable Ingredient filter) {
            this.inputSlots.add((Object)new LayoutSlot(icon, name, x, y, filter));
            return this;
        }

        public Builder addInputSlot(@Nullable Pattern icon, @Nullable String name, int x, int y) {
            return this.addInputSlot(icon, name, x, y, null);
        }

        public Builder addInputSlot(@Nullable Pattern icon, int x, int y) {
            return this.addInputSlot(icon, null, x, y);
        }

        public Builder addInputItem(Pattern icon, ItemLike item, int x, int y) {
            return this.addInputSlot(icon, item.m_5456_().m_5524_(), x, y, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }

        public Builder addInputItem(ItemLike item, int x, int y) {
            return this.addInputItem(new Pattern(Registry.f_122827_.m_7981_((Object)item.m_5456_())), item, x, y);
        }

        public StationSlotLayout build() {
            return new StationSlotLayout(this.translationKey, this.icon, this.sortIndex, this.toolSlot, (List<LayoutSlot>)this.inputSlots.build());
        }

        public Builder translationKey(String translationKey) {
            this.translationKey = translationKey;
            return this;
        }
    }
}

