/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.aoe;

import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.registry.DefaultingLoaderRegistry;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface IAreaOfEffectIterator
extends GenericLoaderRegistry.IHaveLoader {
    public static final IAreaOfEffectIterator DEFAULT = new IAreaOfEffectIterator(){

        @Override
        public Iterable<BlockPos> getBlocks(IToolStackView tool, ItemStack stack, Player player, BlockState state, Level world, BlockPos origin, Direction sideHit, AOEMatchType matchType) {
            return Collections.emptyList();
        }

        public GenericLoaderRegistry.IGenericLoader<? extends IAreaOfEffectIterator> getLoader() {
            throw new UnsupportedOperationException("Attempt to serialize empty AOE iterator");
        }
    };
    public static final DefaultingLoaderRegistry<IAreaOfEffectIterator> LOADER = new DefaultingLoaderRegistry("AOE Iterator", (GenericLoaderRegistry.IHaveLoader)DEFAULT, false);

    public Iterable<BlockPos> getBlocks(IToolStackView var1, ItemStack var2, Player var3, BlockState var4, Level var5, BlockPos var6, Direction var7, AOEMatchType var8);

    public static Predicate<BlockPos> defaultBlockPredicate(IToolStackView tool, ItemStack stack, Level world, BlockPos origin, AOEMatchType matchType) {
        if (matchType == AOEMatchType.BREAKING) {
            float refHardness = world.m_8055_(origin).m_60800_((BlockGetter)world, origin);
            return pos -> {
                BlockState state = world.m_8055_(pos);
                if (state.m_60795_()) {
                    return false;
                }
                float hardness = state.m_60800_((BlockGetter)world, pos);
                if (hardness == -1.0f) {
                    return false;
                }
                if (refHardness == 0.0f ? hardness == 0.0f : hardness / refHardness <= 3.0f) {
                    return ToolHarvestLogic.isEffective(tool, state);
                }
                return false;
            };
        }
        return pos -> !world.m_46859_(pos);
    }

    public static enum AOEMatchType {
        BREAKING,
        TRANSFORM;

    }
}

