/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.materials.definition.LazyMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.ISpecializedRepairRecipe;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.recipe.TinkerStationRepairRecipe;

public class SpecializedRepairRecipe
extends TinkerStationRepairRecipe
implements ISpecializedRepairRecipe {
    public static final RecordLoadable<SpecializedRepairRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)TOOL_FIELD, (RecordField)REPAIR_MATERIAL_FIELD, SpecializedRepairRecipe::new);
    private final Ingredient tool;
    private final LazyMaterial repairMaterial;

    public SpecializedRepairRecipe(ResourceLocation id, Ingredient tool, MaterialId repairMaterialID) {
        super(id);
        this.tool = tool;
        this.repairMaterial = LazyMaterial.of(repairMaterialID);
    }

    @Override
    public MaterialId getRepairMaterial() {
        return this.repairMaterial.getId();
    }

    @Override
    protected MaterialId getPrimaryMaterial(IToolStackView tool) {
        return this.repairMaterial.getId();
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        ItemStack tinkerable = inv.getTinkerableStack();
        if (!this.tool.test(tinkerable) || this.repairMaterial.isUnknown()) {
            return false;
        }
        return SpecializedRepairRecipe.findMaterialItem(inv, this.repairMaterial);
    }

    public static boolean findMaterialItem(ITinkerStationContainer inv, LazyMaterial repairMaterial) {
        boolean found = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            if (!repairMaterial.matches(TinkerStationRepairRecipe.getMaterialFrom(inv, i))) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.specializedRepairSerializer.get();
    }

    @Override
    public Ingredient getTool() {
        return this.tool;
    }
}

