/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.building;

import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.tables.TinkerTables;

public class ToolBuildingRecipe
implements ITinkerStationRecipe {
    public static final RecordLoadable<ToolBuildingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)TinkerLoadables.MODIFIABLE_ITEM.requiredField("result", r -> r.output), (RecordField)IntLoadable.FROM_ONE.defaultField("result_count", (Object)1, true, r -> r.outputCount), (RecordField)IngredientLoadable.DISALLOW_EMPTY.list(0).defaultField("extra_requirements", List.of(), r -> r.ingredients), ToolBuildingRecipe::new).comapFlatMap((recipe, error) -> {
        if (!recipe.output.getToolDefinition().isMultipart() && recipe.ingredients.isEmpty()) {
            throw error.create("Modifiable item must have tool parts or extra requirements to use tool building recipes in " + recipe.id);
        }
        return recipe;
    }, Function.identity());
    protected final ResourceLocation id;
    protected final String group;
    protected final IModifiable output;
    protected final int outputCount;
    protected final List<Ingredient> ingredients;

    public List<Ingredient> getExtraRequirements() {
        return this.ingredients;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.toolBuildingRecipeSerializer.get();
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level worldIn) {
        int i;
        if (!inv.getTinkerableStack().m_41619_()) {
            return false;
        }
        List<PartRequirement> parts = this.output.getToolDefinition().getData().getParts();
        int requiredInputs = parts.size() + this.ingredients.size();
        int maxInputs = inv.getInputCount();
        if (requiredInputs == 0 || requiredInputs > maxInputs) {
            return false;
        }
        int partSize = parts.size();
        for (i = 0; i < partSize; ++i) {
            if (parts.get(i).matches(inv.getInput(i).m_41720_())) continue;
            return false;
        }
        while (i < maxInputs) {
            Ingredient ingredient = (Ingredient)LogicHelper.getOrDefault(this.ingredients, (int)(i - partSize), (Object)Ingredient.f_43901_);
            if (!ingredient.test(inv.getInput(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public ItemStack assemble(ITinkerStationContainer inv) {
        List<MaterialVariant> materials = IntStream.range(0, this.output.getToolDefinition().getData().getParts().size()).mapToObj(i -> MaterialVariant.of(IMaterialItem.getMaterialFromStack(inv.getInput(i)))).toList();
        return ToolStack.createTool(this.output.m_5456_(), this.output.getToolDefinition(), new MaterialNBT(materials)).createStack(this.outputCount);
    }

    @Deprecated
    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)this.output);
    }

    public ToolBuildingRecipe(ResourceLocation id, String group, IModifiable output, int outputCount, List<Ingredient> ingredients) {
        this.id = id;
        this.group = group;
        this.output = output;
        this.outputCount = outputCount;
        this.ingredients = ingredients;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public IModifiable getOutput() {
        return this.output;
    }
}

