/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.IdExtender;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierSalvage;
import slimeknights.tconstruct.library.recipe.modifiers.adding.MultilevelModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class MultilevelModifierRecipeBuilder
extends AbstractRecipeBuilder<MultilevelModifierRecipeBuilder> {
    private final ModifierId result;
    private final List<MultilevelModifierRecipe.LevelEntry> levels = new ArrayList<MultilevelModifierRecipe.LevelEntry>();
    private final List<SizedIngredient> inputs = new ArrayList<SizedIngredient>();
    private boolean allowCrystal = true;
    private Ingredient tools = Ingredient.f_43901_;
    private int maxToolSize = 16;

    public MultilevelModifierRecipeBuilder setTools(Ingredient tools, int maxSize) {
        this.tools = tools;
        this.maxToolSize = maxSize;
        return this;
    }

    public MultilevelModifierRecipeBuilder setTools(Ingredient tools) {
        return this.setTools(tools, 16);
    }

    public MultilevelModifierRecipeBuilder setTools(TagKey<Item> tag) {
        return this.setTools(Ingredient.m_204132_(tag));
    }

    public MultilevelModifierRecipeBuilder addInput(SizedIngredient ingredient) {
        this.inputs.add(ingredient);
        return this;
    }

    public MultilevelModifierRecipeBuilder addInput(Ingredient ingredient) {
        return this.addInput(SizedIngredient.of((Ingredient)ingredient));
    }

    public MultilevelModifierRecipeBuilder addInput(ItemLike item, int amount) {
        return this.addInput(SizedIngredient.fromItems((int)amount, (ItemLike[])new ItemLike[]{item}));
    }

    public MultilevelModifierRecipeBuilder addInput(ItemLike item) {
        return this.addInput(item, 1);
    }

    public MultilevelModifierRecipeBuilder addInput(TagKey<Item> tag, int amount) {
        return this.addInput(SizedIngredient.fromTag(tag, (int)amount));
    }

    public MultilevelModifierRecipeBuilder addInput(TagKey<Item> tag) {
        return this.addInput(tag, 1);
    }

    public MultilevelModifierRecipeBuilder allowCrystal() {
        this.allowCrystal = true;
        return this;
    }

    public MultilevelModifierRecipeBuilder disallowCrystal() {
        this.allowCrystal = false;
        return this;
    }

    private MultilevelModifierRecipeBuilder addLevelRange(@Nullable SlotType.SlotCount slots, int minLevel, int maxLevel) {
        if (minLevel > maxLevel) {
            throw new JsonSyntaxException("minLevel must be less than or equal to maxLevel");
        }
        if (!this.levels.isEmpty() && minLevel <= this.levels.get(this.levels.size() - 1).level().max()) {
            throw new JsonSyntaxException("Level range must be greater than previous range");
        }
        this.levels.add(new MultilevelModifierRecipe.LevelEntry(slots, ModifierEntry.VALID_LEVEL.range(minLevel, maxLevel)));
        return this;
    }

    public MultilevelModifierRecipeBuilder addLevelRange(SlotType slot, int slotCount, int minLevel, int maxLevel) {
        return this.addLevelRange(new SlotType.SlotCount(slot, slotCount), minLevel, maxLevel);
    }

    public MultilevelModifierRecipeBuilder addLevel(SlotType slot, int slotCount, int level) {
        return this.addLevelRange(slot, slotCount, level, level);
    }

    public MultilevelModifierRecipeBuilder addMinLevel(SlotType slot, int slotCount, int level) {
        return this.addLevelRange(slot, slotCount, level, Short.MAX_VALUE);
    }

    public MultilevelModifierRecipeBuilder addLevelRange(int minLevel, int maxLevel) {
        return this.addLevelRange(null, minLevel, maxLevel);
    }

    public MultilevelModifierRecipeBuilder addLevel(int level) {
        return this.addLevelRange(level, level);
    }

    public MultilevelModifierRecipeBuilder addMinLevel(int level) {
        return this.addLevelRange(level, Short.MAX_VALUE);
    }

    public MultilevelModifierRecipeBuilder saveSalvage(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.levels.isEmpty()) {
            throw new IllegalStateException("Must have at least 1 level");
        }
        for (MultilevelModifierRecipe.LevelEntry levelEntry : this.levels) {
            if (levelEntry.slots() == null) continue;
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new ModifierSalvage(IdExtender.LocationExtender.INSTANCE.suffix(id, "_level_" + levelEntry.level().min()), this.tools, this.maxToolSize, this.result, levelEntry.level(), levelEntry.slots()), ModifierSalvage.LOADER, null));
        }
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumerIn) {
        this.save(consumerIn, this.result);
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.inputs.isEmpty() && !this.allowCrystal) {
            throw new IllegalStateException("Must either have at least 1 input or allow crystal");
        }
        if (this.levels.isEmpty()) {
            throw new IllegalStateException("Must have at least 1 level");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new MultilevelModifierRecipe(id, this.inputs, this.tools, this.maxToolSize, this.result, this.allowCrystal, this.levels), MultilevelModifierRecipe.LOADER, advancementId));
    }

    private void writeCommon(JsonObject json) {
        Ingredient ingredient = this.tools;
        if (this.tools == Ingredient.f_43901_) {
            ingredient = Ingredient.m_204132_(TinkerTags.Items.MODIFIABLE);
        }
        json.add("tools", ingredient.m_43942_());
        if (this.maxToolSize != 16) {
            json.addProperty("max_tool_size", (Number)this.maxToolSize);
        }
    }

    private MultilevelModifierRecipeBuilder(ModifierId result) {
        this.result = result;
    }

    public static MultilevelModifierRecipeBuilder modifier(ModifierId result) {
        return new MultilevelModifierRecipeBuilder(result);
    }

    private class FinishedSalvage
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        private final SlotType.SlotCount slots;
        private final int minLevel;
        private final int maxLevel;

        public FinishedSalvage(ResourceLocation id, SlotType.SlotCount slots, int minLevel, int maxLevel) {
            super((AbstractRecipeBuilder)MultilevelModifierRecipeBuilder.this, id, null);
            this.slots = slots;
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
        }

        public void m_7917_(JsonObject json) {
            MultilevelModifierRecipeBuilder.this.writeCommon(json);
            JsonObject slotJson = new JsonObject();
            slotJson.addProperty(this.slots.type().getName(), (Number)this.slots.count());
            json.add("slots", (JsonElement)slotJson);
            json.addProperty("modifier", MultilevelModifierRecipeBuilder.this.result.toString());
            json.addProperty("min_level", (Number)this.minLevel);
            if (this.maxLevel != Short.MAX_VALUE) {
                json.addProperty("max_level", (Number)this.maxLevel);
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TinkerModifiers.modifierSalvageSerializer.get();
        }
    }
}

