/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class IncrementalModifierRecipe
extends AbstractModifierRecipe {
    public static final RecordLoadable<IncrementalModifierRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("input", r -> r.input), (RecordField)IntLoadable.FROM_ONE.defaultField("amount_per_item", (Object)1, true, r -> r.amountPerInput), (RecordField)IntLoadable.FROM_ONE.requiredField("needed_per_level", r -> r.neededPerLevel), (RecordField)TOOLS_FIELD, (RecordField)MAX_TOOL_SIZE_FIELD, (RecordField)RESULT_FIELD, (RecordField)LEVEL_FIELD, (RecordField)SLOTS_FIELD, (RecordField)ItemOutput.Loadable.OPTIONAL_STACK.emptyField("leftover", r -> r.leftover), (RecordField)ALLOW_CRYSTAL_FIELD, IncrementalModifierRecipe::new);
    private final Ingredient input;
    private final int amountPerInput;
    private final int neededPerLevel;
    private final ItemOutput leftover;
    private List<List<ItemStack>> slotCache;

    public IncrementalModifierRecipe(ResourceLocation id, Ingredient input, int amountPerInput, int neededPerLevel, Ingredient toolRequirement, int maxToolSize, ModifierId result, IntRange level, @Nullable SlotType.SlotCount slots, ItemOutput leftover, boolean allowCrystal) {
        super(id, toolRequirement, maxToolSize, result, level, slots, allowCrystal);
        this.input = input;
        this.amountPerInput = amountPerInput;
        this.neededPerLevel = neededPerLevel;
        this.leftover = leftover;
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level level) {
        if (!this.result.isBound() || !this.toolRequirement.test(inv.getTinkerableStack())) {
            return false;
        }
        return this.matchesCrystal(inv) || IncrementalModifierRecipe.containsOnlyIngredient(inv, this.input);
    }

    @Override
    public RecipeResult<ItemStack> getValidatedResult(ITinkerStationContainer inv) {
        SlotType.SlotCount slots;
        Component commonError;
        ItemStack tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        ModifierId modifier = this.result.getId();
        boolean newLevel = tool.getUpgrades().getEntry(modifier).getAmount(0) <= 0;
        boolean crystal = this.matchesCrystal(inv);
        if ((crystal || newLevel) && (commonError = this.validatePrerequisites(tool)) != null) {
            return RecipeResult.failure(commonError);
        }
        tool = tool.copy();
        if ((crystal || newLevel) && (slots = this.getSlots()) != null) {
            tool.getPersistentData().addSlots(slots.type(), -slots.count());
        }
        if (crystal) {
            tool.addModifier(modifier, 1);
        } else {
            tool.addModifierAmount(modifier, IncrementalModifierRecipe.getAvailableAmount(inv, this.input, this.amountPerInput), this.neededPerLevel);
        }
        return RecipeResult.success(tool.createStack(Math.min(tinkerable.m_41613_(), this.shrinkToolSlotBy())));
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        if (this.matchesCrystal(inv)) {
            super.updateInputs(result, inv, isServer);
            return;
        }
        ToolStack inputTool = ToolStack.from(inv.getTinkerableStack());
        ToolStack resultTool = ToolStack.from(result);
        ModifierId modifier = this.result.getId();
        ModifierEntry inputEntry = inputTool.getUpgrades().getEntry(modifier);
        ModifierEntry resultEntry = resultTool.getUpgrades().getEntry(modifier);
        int inputNeed = inputEntry.getNeeded();
        if (inputNeed == 0 || inputNeed == this.neededPerLevel) {
            IncrementalModifierRecipe.updateInputs(inv, this.input, resultEntry.getAmount(this.neededPerLevel) - inputEntry.getAmount(0), this.amountPerInput, this.leftover.get());
        } else {
            int gcd = IntMath.gcd((int)inputNeed, (int)this.neededPerLevel);
            int recipeScale = inputNeed / gcd;
            int used = resultEntry.getAmount(this.neededPerLevel) * recipeScale - inputEntry.getAmount(0) * this.neededPerLevel / gcd;
            IncrementalModifierRecipe.updateInputs(inv, this.input, (used + recipeScale - 1) / recipeScale, this.amountPerInput, this.leftover.get());
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.incrementalModifierSerializer.get();
    }

    @Override
    public boolean isIncremental() {
        return true;
    }

    private List<List<ItemStack>> getInputs() {
        if (this.slotCache == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            List<ItemStack> items = Arrays.asList(this.input.m_43908_());
            int maxStackSize = items.stream().mapToInt(ItemStack::m_41741_).min().orElse(64);
            int needed = this.neededPerLevel / this.amountPerInput;
            if (this.neededPerLevel % this.amountPerInput > 0) {
                ++needed;
            }
            Lazy fullSize = Lazy.of(() -> items.stream().map(stack -> ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)maxStackSize)).collect(Collectors.toList()));
            while (needed > maxStackSize) {
                builder.add((Object)((List)fullSize.get()));
                needed -= maxStackSize;
            }
            if (needed > 0) {
                int remaining = needed;
                builder.add(items.stream().map(stack -> ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remaining)).collect(Collectors.toList()));
            }
            this.slotCache = builder.build();
        }
        return this.slotCache;
    }

    @Override
    public int getInputCount() {
        return this.getInputs().size();
    }

    @Override
    public List<ItemStack> getDisplayItems(int slot) {
        List<List<ItemStack>> inputs = this.getInputs();
        if (slot >= 0 && slot < inputs.size()) {
            return inputs.get(slot);
        }
        return Collections.emptyList();
    }

    public static boolean containsOnlyIngredient(ITinkerableContainer inv, Ingredient ingredient) {
        boolean found = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            if (ingredient.test(stack)) {
                found = true;
                continue;
            }
            return false;
        }
        return found;
    }

    public static int getAvailableAmount(ITinkerStationContainer inv, Ingredient ingredient, int amountPerItem) {
        int available = 0;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_() || !ingredient.test(stack)) continue;
            available += stack.m_41613_() * amountPerItem;
        }
        return available;
    }

    public static void updateInputs(IMutableTinkerStationContainer inv, Ingredient ingredient, int amountNeeded, int amountPerInput, ItemStack leftover) {
        int itemsNeeded = amountNeeded / amountPerInput;
        int leftoverAmount = amountNeeded % amountPerInput;
        if (leftoverAmount > 0) {
            ++itemsNeeded;
            if (!leftover.m_41619_()) {
                inv.giveItem(ItemHandlerHelper.copyStackWithSize((ItemStack)leftover, (int)((amountPerInput - leftoverAmount) * leftover.m_41613_())));
            }
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_() || !ingredient.test(stack)) continue;
            int count = stack.m_41613_();
            if (count > itemsNeeded) {
                inv.shrinkInput(i, itemsNeeded);
                break;
            }
            inv.shrinkInput(i, count);
            itemsNeeded -= count;
        }
    }

    @Deprecated
    public static ItemStack deseralizeResultItem(JsonObject parent, String name) {
        return JsonUtils.getAsItemStack(parent, name);
    }
}

