/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;

public abstract class AbstractModifierRecipe
implements ITinkerStationRecipe,
IDisplayModifierRecipe {
    protected static final String KEY_MIN_LEVEL = TConstruct.makeTranslationKey("recipe", "modifier.min_level");
    protected static final String KEY_MAX_LEVEL = TConstruct.makeTranslationKey("recipe", "modifier.max_level");
    protected static final String KEY_NOT_ENOUGH_SLOTS = TConstruct.makeTranslationKey("recipe", "modifier.not_enough_slots");
    protected static final String KEY_NOT_ENOUGH_SLOT = TConstruct.makeTranslationKey("recipe", "modifier.not_enough_slot");
    protected static final LoadableField<Ingredient, AbstractModifierRecipe> TOOLS_FIELD = IngredientLoadable.DISALLOW_EMPTY.requiredField("tools", r -> r.toolRequirement);
    protected static final LoadableField<Integer, AbstractModifierRecipe> MAX_TOOL_SIZE_FIELD = IntLoadable.FROM_ONE.defaultField("max_tool_size", (Object)16, r -> r.maxToolSize);
    protected static final LoadableField<ModifierId, AbstractModifierRecipe> RESULT_FIELD = ModifierId.PARSER.requiredField("result", r -> r.result.getId());
    protected static final LoadableField<IntRange, AbstractModifierRecipe> LEVEL_FIELD = ModifierEntry.VALID_LEVEL.defaultField("level", r -> r.level);
    protected static final LoadableField<SlotType.SlotCount, AbstractModifierRecipe> SLOTS_FIELD = SlotType.SlotCount.LOADABLE.nullableField("slots", r -> r.slots);
    protected static final LoadableField<Boolean, AbstractModifierRecipe> ALLOW_CRYSTAL_FIELD = BooleanLoadable.INSTANCE.defaultField("allow_crystal", Boolean.valueOf(true), r -> r.allowCrystal);
    private final ResourceLocation id;
    protected final Ingredient toolRequirement;
    protected final int maxToolSize;
    protected final LazyModifier result;
    private final IntRange level;
    @Nullable
    private final SlotType.SlotCount slots;
    protected final boolean allowCrystal;
    @Nullable
    private List<ItemStack> toolInputs = null;
    private List<ItemStack> displayInputs = null;
    List<ItemStack> toolWithModifier = null;
    private ModifierEntry displayResult;

    protected AbstractModifierRecipe(ResourceLocation id, Ingredient toolRequirement, int maxToolSize, ModifierId result, IntRange level, @Nullable SlotType.SlotCount slots, boolean allowCrystal) {
        this.id = id;
        this.toolRequirement = toolRequirement;
        this.maxToolSize = maxToolSize;
        this.result = new LazyModifier(result);
        this.level = level;
        this.slots = slots;
        this.allowCrystal = allowCrystal;
        ModifierRecipeLookup.addRecipeModifier(SlotType.SlotCount.type(slots), this.result);
    }

    @Override
    public abstract RecipeResult<ItemStack> getValidatedResult(ITinkerStationContainer var1);

    @Deprecated
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Override
    public int shrinkToolSlotBy() {
        return this.maxToolSize;
    }

    protected List<ItemStack> getToolInputs() {
        if (this.toolInputs == null) {
            this.toolInputs = Arrays.stream(this.toolRequirement.m_43908_()).map(stack -> {
                if (stack.m_41720_() instanceof IModifiableDisplay) {
                    return ((IModifiableDisplay)stack.m_41720_()).getRenderTool();
                }
                return stack;
            }).collect(Collectors.toList());
        }
        return this.toolInputs;
    }

    @Override
    public ModifierEntry getDisplayResult() {
        if (this.displayResult == null) {
            this.displayResult = new ModifierEntry(this.result, this.level.min());
        }
        return this.displayResult;
    }

    @Override
    public List<ItemStack> getToolWithoutModifier() {
        if (this.displayInputs == null) {
            int min = this.level.min() - 1;
            ModifierEntry existing = min > 0 ? new ModifierEntry(this.result, min) : null;
            ModifierEntry displayResult = this.getDisplayResult();
            this.displayInputs = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, IDisplayModifierRecipe.modifiersForResult(displayResult, existing))).collect(Collectors.toList());
        }
        return this.displayInputs;
    }

    @Override
    public List<ItemStack> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            ModifierEntry result = this.getDisplayResult();
            this.toolWithModifier = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, IDisplayModifierRecipe.modifiersForResult(result, result))).collect(Collectors.toList());
        }
        return this.toolWithModifier;
    }

    public static boolean matchesCrystal(ITinkerStationContainer container, ModifierId match) {
        boolean found = false;
        for (int i = 0; i < container.getInputCount(); ++i) {
            ItemStack stack = container.getInput(i);
            if (stack.m_41619_()) continue;
            if (found || !stack.m_150930_(TinkerModifiers.modifierCrystal.m_5456_())) {
                return false;
            }
            ModifierId modifier = ModifierCrystalItem.getModifier(stack);
            if (!match.equals((Object)modifier)) {
                return false;
            }
            found = true;
        }
        return found;
    }

    protected boolean matchesCrystal(ITinkerStationContainer container) {
        return this.allowCrystal && AbstractModifierRecipe.matchesCrystal(container, this.result.getId());
    }

    @Nullable
    protected Component validateLevel(int resultLevel) {
        if (resultLevel < this.level.min()) {
            return Component.m_237110_((String)KEY_MIN_LEVEL, (Object[])new Object[]{this.result.get().getDisplayName(this.level.min() - 1)});
        }
        if (resultLevel > this.level.max()) {
            return Component.m_237110_((String)KEY_MAX_LEVEL, (Object[])new Object[]{this.result.get().getDisplayName(), this.level.max()});
        }
        return null;
    }

    @Nullable
    protected static Component checkSlots(IToolStackView tool, @Nullable SlotType.SlotCount slots) {
        if (slots != null) {
            int count = slots.count();
            if (tool.getFreeSlots(slots.type()) < count) {
                if (count == 1) {
                    return Component.m_237110_((String)KEY_NOT_ENOUGH_SLOT, (Object[])new Object[]{slots.type().getDisplayName()});
                }
                return Component.m_237110_((String)KEY_NOT_ENOUGH_SLOTS, (Object[])new Object[]{count, slots.type().getDisplayName()});
            }
        }
        return null;
    }

    @Nullable
    protected Component validatePrerequisites(IToolStackView tool, int resultLevel) {
        Component error = this.validateLevel(resultLevel);
        if (error != null) {
            return error;
        }
        return AbstractModifierRecipe.checkSlots(tool, this.slots);
    }

    @Nullable
    protected Component validatePrerequisites(IToolStackView tool) {
        return this.validatePrerequisites(tool, tool.getModifierLevel(this.result.getId()) + 1);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.id + "}";
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public IntRange getLevel() {
        return this.level;
    }

    @Override
    @Nullable
    public SlotType.SlotCount getSlots() {
        return this.slots;
    }
}

