/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialCastingRecipeBuilder
extends AbstractRecipeBuilder<MaterialCastingRecipeBuilder> {
    private final IMaterialItem result;
    private final TypeAwareRecipeSerializer<? extends MaterialCastingRecipe> recipeSerializer;
    private Ingredient cast = Ingredient.f_43901_;
    private int itemCost = 0;
    private boolean consumed = false;
    private boolean switchSlots = false;

    public static MaterialCastingRecipeBuilder basinRecipe(IMaterialItem result) {
        return MaterialCastingRecipeBuilder.castingRecipe(result, (TypeAwareRecipeSerializer<? extends MaterialCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.basinMaterialSerializer.get()));
    }

    public static MaterialCastingRecipeBuilder tableRecipe(IMaterialItem result) {
        return MaterialCastingRecipeBuilder.castingRecipe(result, (TypeAwareRecipeSerializer<? extends MaterialCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.tableMaterialSerializer.get()));
    }

    public MaterialCastingRecipeBuilder setCast(TagKey<Item> tag, boolean consumed) {
        return this.setCast(Ingredient.m_204132_(tag), consumed);
    }

    public MaterialCastingRecipeBuilder setCast(ItemLike item, boolean consumed) {
        return this.setCast(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), consumed);
    }

    public MaterialCastingRecipeBuilder setCast(Ingredient cast, boolean consumed) {
        this.cast = cast;
        this.consumed = consumed;
        return this;
    }

    public MaterialCastingRecipeBuilder setSwitchSlots() {
        this.switchSlots = true;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Registry.f_122827_.m_7981_((Object)this.result.m_5456_()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.itemCost <= 0) {
            throw new IllegalStateException("Material casting recipes require a positive amount of fluid");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new MaterialCastingRecipe(this.recipeSerializer, id, this.group, this.cast, this.itemCost, this.result, this.consumed, this.switchSlots), MaterialCastingRecipe.LOADER, advancementId));
    }

    private MaterialCastingRecipeBuilder(IMaterialItem result, TypeAwareRecipeSerializer<? extends MaterialCastingRecipe> recipeSerializer) {
        this.result = result;
        this.recipeSerializer = recipeSerializer;
    }

    public static MaterialCastingRecipeBuilder castingRecipe(IMaterialItem result, TypeAwareRecipeSerializer<? extends MaterialCastingRecipe> recipeSerializer) {
        return new MaterialCastingRecipeBuilder(result, recipeSerializer);
    }

    public MaterialCastingRecipeBuilder setItemCost(int itemCost) {
        this.itemCost = itemCost;
        return this;
    }
}

