/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.unserializable;

import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierHookProvider;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record ArmorLevelModule(TinkerDataCapability.TinkerDataKey<Integer> key, boolean allowBroken) implements ModifierHookProvider,
EquipmentChangeModifierHook
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = ModifierModule.defaultHooks(TinkerHooks.EQUIPMENT_CHANGE);

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        ArmorLevelModule.addLevelsIfArmor(tool, context, this.key, modifier.intEffectiveLevel(), this.allowBroken);
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        ArmorLevelModule.addLevelsIfArmor(tool, context, this.key, -modifier.intEffectiveLevel(), this.allowBroken);
    }

    public static void addLevels(EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Integer> key, int amount) {
        context.getTinkerData().ifPresent(data -> {
            int totalLevels = data.get(key, 0) + amount;
            if (totalLevels <= 0) {
                data.remove(key);
            } else {
                data.put(key, totalLevels);
            }
        });
    }

    public static void addLevelsIfArmor(IToolStackView tool, EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Integer> key, int amount, boolean allowBroken) {
        if (ModifierUtil.validArmorSlot(tool, context.getChangedSlot()) && (allowBroken || !tool.isBroken())) {
            ArmorLevelModule.addLevels(context, key, amount);
        }
    }

    public static int getLevel(LivingEntity living, TinkerDataCapability.TinkerDataKey<Integer> key) {
        return living.getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> (Integer)data.get(key)).orElse(0);
    }
}

