/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.mining;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.mining.MiningSpeedFormula;
import slimeknights.tconstruct.library.json.variable.mining.MiningSpeedVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.modifiers.modules.behavior.ConditionalStatTooltip;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record ConditionalMiningSpeedModule(IJsonPredicate<BlockState> block, IJsonPredicate<LivingEntity> holder, boolean requireEffective, MiningSpeedFormula formula, ModifierModuleCondition condition) implements BreakSpeedModifierHook,
ConditionalStatTooltip,
ModifierModule,
ModifierModuleCondition.ConditionalModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.BREAK_SPEED, TinkerHooks.TOOLTIP);
    public static final RecordLoadable<ConditionalMiningSpeedModule> LOADER = RecordLoadable.create((RecordField)BlockPredicate.LOADER.defaultField("blocks", ConditionalMiningSpeedModule::block), (RecordField)LivingEntityPredicate.LOADER.defaultField("entity", ConditionalMiningSpeedModule::holder), (RecordField)BooleanLoadable.INSTANCE.defaultField("require_effective", Boolean.valueOf(true), ConditionalMiningSpeedModule::requireEffective), (RecordField)MiningSpeedFormula.LOADER.directField(ConditionalMiningSpeedModule::formula), ModifierModuleCondition.FIELD, ConditionalMiningSpeedModule::new);

    @Override
    public boolean percent() {
        return this.formula.percent();
    }

    @Override
    @Nullable
    public Integer getPriority() {
        return this.percent() ? Integer.valueOf(75) : null;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Player player = event.getEntity();
        if ((isEffective || !this.requireEffective) && this.condition.matches(tool, modifier) && this.block.matches((Object)event.getState()) && this.holder.matches((Object)player)) {
            event.setNewSpeed(this.formula.apply(tool, modifier, event, player, sideHit, event.getOriginalSpeed(), event.getNewSpeed(), miningSpeedModifier));
        }
    }

    @Override
    public INumericToolStat<?> stat() {
        return ToolStats.MINING_SPEED;
    }

    @Override
    public float computeTooltipValue(IToolStackView tool, ModifierEntry entry, @Nullable Player player) {
        return this.formula.apply(tool, entry, null, player, null, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends VariableFormula.Builder<Builder, ConditionalMiningSpeedModule, MiningSpeedVariable> {
        private IJsonPredicate<BlockState> blocks = BlockPredicate.ANY;
        private IJsonPredicate<LivingEntity> holder = LivingEntityPredicate.ANY;
        private boolean requireEffective = true;

        private Builder() {
            super(MiningSpeedFormula.VARIABLES);
        }

        public Builder allowIneffective() {
            this.requireEffective = false;
            return this;
        }

        @Override
        protected ConditionalMiningSpeedModule build(ModifierFormula formula) {
            return new ConditionalMiningSpeedModule(this.blocks, this.holder, this.requireEffective, new MiningSpeedFormula(formula, this.variables, this.percent), this.condition);
        }

        public Builder blocks(IJsonPredicate<BlockState> blocks) {
            this.blocks = blocks;
            return this;
        }

        public Builder holder(IJsonPredicate<LivingEntity> holder) {
            this.holder = holder;
            return this;
        }
    }
}

