/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.fluid;

import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.fluid.TankCapacityModule;
import slimeknights.tconstruct.library.tools.capability.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class TankModule
extends TankCapacityModule
implements ToolFluidCapability.FluidModifierHook,
TooltipModifierHook {
    private static final String FILLED_KEY = TConstruct.makeTranslationKey("modifier", "tank.filled");
    private static final String CAPACITY_KEY = TConstruct.makeTranslationKey("modifier", "tank.capacity");
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.VOLATILE_DATA, ToolFluidCapability.HOOK, TinkerHooks.TOOLTIP);
    public static final ResourceLocation DEFAULT_OWNER_KEY = TConstruct.getResource("tank_owner");
    public static final ResourceLocation DEFAULT_FLUID_KEY = TConstruct.getResource("tank_fluid");
    public static final RecordLoadable<TankModule> LOADER = RecordLoadable.create((RecordField)CAPACITY_KEY_FIELD, (RecordField)CAPACITY_FIELD, (RecordField)SCALE_CAPACITY_FIELD, (RecordField)Loadables.RESOURCE_LOCATION.defaultField("fluid_key", (Object)DEFAULT_FLUID_KEY, TankModule::getFluidKey), (RecordField)Loadables.RESOURCE_LOCATION.defaultField("owner_key", (Object)DEFAULT_OWNER_KEY, TankModule::getOwnerKey), TankModule::new);
    public static final BiFunction<CompoundTag, String, FluidStack> PARSE_FLUID = (nbt, key) -> FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_(key));
    private final ResourceLocation ownerKey;
    private final ResourceLocation fluidKey;

    public TankModule(ResourceLocation capacityKey, int capacity, boolean scaleCapacity, ResourceLocation fluidKey, ResourceLocation ownerKey) {
        super(capacityKey, capacity, scaleCapacity);
        this.ownerKey = ownerKey;
        this.fluidKey = fluidKey;
    }

    public TankModule(int capacity, boolean scaleCapacity) {
        this(DEFAULT_CAPACITY_KEY, capacity, scaleCapacity, DEFAULT_FLUID_KEY, DEFAULT_OWNER_KEY);
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (this.isOwner(tool, modifier.getId())) {
            FluidStack current = this.getFluid(tool);
            if (!current.isEmpty()) {
                tooltip.add((Component)Component.m_237110_((String)FILLED_KEY, (Object[])new Object[]{current.getAmount(), current.getDisplayName()}));
            }
            tooltip.add((Component)Component.m_237110_((String)CAPACITY_KEY, (Object[])new Object[]{this.getCapacity(tool)}));
        }
    }

    public boolean isOwner(IToolContext tool, ModifierId modifier) {
        ResourceLocation key = this.getOwnerKey();
        if (key == null) {
            return true;
        }
        return modifier.toString().equals(tool.getVolatileData().getString(key));
    }

    @Override
    public int getTanks(IToolContext tool, Modifier modifier) {
        return this.isOwner(tool, modifier.getId()) ? 1 : 0;
    }

    @Override
    public int getTankCapacity(IToolStackView tool, ModifierEntry modifier, int tank) {
        return this.getCapacity(tool);
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        super.addVolatileData(context, modifier, volatileData);
        ResourceLocation ownerKey = this.getOwnerKey();
        if (!volatileData.contains(ownerKey, 8)) {
            volatileData.putString(ownerKey, modifier.getId().toString());
        }
        ToolFluidCapability.addTanks(context, modifier.getModifier(), volatileData, this);
    }

    public FluidStack getFluid(IToolStackView tool) {
        return tool.getPersistentData().get(this.getFluidKey(), PARSE_FLUID);
    }

    public FluidStack setFluid(IToolStackView tool, FluidStack fluid) {
        if (fluid.isEmpty()) {
            tool.getPersistentData().remove(this.getFluidKey());
            return fluid;
        }
        int capacity = this.getCapacity(tool);
        if (fluid.getAmount() > capacity) {
            fluid.setAmount(capacity);
        }
        tool.getPersistentData().put(this.getFluidKey(), (Tag)fluid.writeToNBT(new CompoundTag()));
        return fluid;
    }

    @Override
    public FluidStack getFluidInTank(IToolStackView tool, ModifierEntry modifier, int tank) {
        return this.getFluid(tool);
    }

    @Override
    public int fill(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
        if (!resource.isEmpty() && this.isOwner(tool, modifier.getId())) {
            FluidStack current = this.getFluid(tool);
            int capacity = this.getCapacity(tool);
            if (current.isEmpty()) {
                if (action.execute()) {
                    this.setFluid(tool, resource);
                }
                return Math.min(resource.getAmount(), capacity);
            }
            if (current.getAmount() < capacity && current.isFluidEqual(resource)) {
                int filled = Math.min(resource.getAmount(), capacity - current.getAmount());
                if (filled > 0 && action.execute()) {
                    current.grow(filled);
                    this.setFluid(tool, current);
                }
                return filled;
            }
        }
        return 0;
    }

    @Override
    public FluidStack drain(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack current;
        if (!resource.isEmpty() && this.isOwner(tool, modifier.getId()) && !(current = this.getFluid(tool)).isEmpty() && current.isFluidEqual(resource)) {
            FluidStack drained = new FluidStack(current, Math.min(current.getAmount(), resource.getAmount()));
            if (action.execute()) {
                if (drained.getAmount() == current.getAmount()) {
                    this.setFluid(tool, FluidStack.EMPTY);
                } else {
                    current.shrink(drained.getAmount());
                    this.setFluid(tool, current);
                }
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack drain(IToolStackView tool, ModifierEntry modifier, int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack current;
        if (maxDrain > 0 && this.isOwner(tool, modifier.getId()) && !(current = this.getFluid(tool)).isEmpty()) {
            FluidStack drained = new FluidStack(current, Math.min(current.getAmount(), maxDrain));
            if (action.execute()) {
                if (drained.getAmount() == current.getAmount()) {
                    this.setFluid(tool, FluidStack.EMPTY);
                } else {
                    current.shrink(drained.getAmount());
                    this.setFluid(tool, current);
                }
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public ResourceLocation getOwnerKey() {
        return this.ownerKey;
    }

    public ResourceLocation getFluidKey() {
        return this.fluidKey;
    }
}

