/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.combat;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.AttributeModuleBuilder;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record MeleeAttributeModule(String unique, Attribute attribute, UUID uuid, AttributeModifier.Operation operation, LevelingValue amount, ModifierModuleCondition condition) implements ModifierModule,
MeleeHitModifierHook,
ModifierModuleCondition.ConditionalModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.MELEE_HIT);
    public static final RecordLoadable<MeleeAttributeModule> LOADER = RecordLoadable.create((RecordField)StringLoadable.DEFAULT.requiredField("unique", MeleeAttributeModule::unique), (RecordField)Loadables.ATTRIBUTE.requiredField("attribute", MeleeAttributeModule::attribute), (RecordField)TinkerLoadables.OPERATION.requiredField("operation", MeleeAttributeModule::operation), (RecordField)LevelingValue.LOADABLE.directField(MeleeAttributeModule::amount), ModifierModuleCondition.FIELD, MeleeAttributeModule::new);

    public MeleeAttributeModule(String unique, Attribute attribute, AttributeModifier.Operation operation, LevelingValue amount, ModifierModuleCondition condition) {
        this(unique, attribute, UUID.nameUUIDFromBytes(unique.getBytes()), operation, amount, condition);
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        AttributeInstance instance;
        LivingEntity target;
        if (this.condition.matches(tool, modifier) && (target = context.getLivingTarget()) != null && (instance = target.m_21051_(this.attribute)) != null) {
            instance.m_22118_(new AttributeModifier(this.uuid, this.unique, (double)this.amount.compute(modifier.getEffectiveLevel()), this.operation));
        }
        return knockback;
    }

    private void removeAttribute(@Nullable LivingEntity target) {
        AttributeInstance instance;
        if (target != null && (instance = target.m_21051_(this.attribute)) != null) {
            instance.m_22120_(this.uuid);
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        this.removeAttribute(context.getLivingTarget());
    }

    @Override
    public void failedMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageAttempted) {
        this.removeAttribute(context.getLivingTarget());
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder builder(Attribute attribute, AttributeModifier.Operation operation) {
        return new Builder(attribute, operation);
    }

    public static class Builder
    extends AttributeModuleBuilder<Builder, MeleeAttributeModule> {
        private Builder(Attribute attribute, AttributeModifier.Operation operation) {
            super(attribute, operation);
        }

        @Override
        public MeleeAttributeModule amount(float flat, float eachLevel) {
            if (this.unique == null) {
                throw new IllegalStateException("Must set unique for attributes");
            }
            return new MeleeAttributeModule(this.unique, this.attribute, this.operation, new LevelingValue(flat, eachLevel), this.condition);
        }
    }
}

