/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.build;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record SetStatModule<T>(IToolStat<T> stat, T value, ModifierModuleCondition condition) implements ModifierModule,
ToolStatsModifierHook
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.TOOL_STATS);
    public static final RecordLoadable<SetStatModule<?>> LOADER = new RecordLoadable<SetStatModule<?>>(){

        public SetStatModule<?> deserialize(JsonObject json, TypedMap<Object> context) {
            return 1.deserialize(json, (IToolStat)ToolStats.LOADER.getIfPresent(json, "stat"));
        }

        private static <T> SetStatModule<T> deserialize(JsonObject json, IToolStat<T> stat) {
            ModifierModuleCondition condition = ModifierModuleCondition.deserializeFrom(json);
            T value = stat.deserialize(JsonHelper.getElement((JsonObject)json, (String)"value"));
            return new SetStatModule<T>(stat, value, condition);
        }

        public void serialize(SetStatModule<?> object, JsonObject json) {
            object.condition.serializeInto(json);
            json.add("stat", ToolStats.LOADER.serialize(object.stat));
            1.serializeValue(object, json);
        }

        private static <T> void serializeValue(SetStatModule<T> module, JsonObject json) {
            json.add("value", module.stat.serialize(module.value));
        }

        public SetStatModule<?> decode(FriendlyByteBuf buffer, TypedMap<Object> context) {
            return 1.decode(buffer, (IToolStat)ToolStats.LOADER.decode(buffer));
        }

        private static <T> SetStatModule<T> decode(FriendlyByteBuf buffer, IToolStat<T> stat) {
            T value = stat.fromNetwork(buffer);
            ModifierModuleCondition condition = ModifierModuleCondition.fromNetwork(buffer);
            return new SetStatModule<T>(stat, value, condition);
        }

        public void encode(FriendlyByteBuf buffer, SetStatModule<?> object) {
            ToolStats.LOADER.encode(buffer, object.stat);
            1.writeValue(object, buffer);
            object.condition.toNetwork(buffer);
        }

        private static <T> void writeValue(SetStatModule<T> object, FriendlyByteBuf buffer) {
            object.stat.toNetwork(buffer, object.value);
        }
    };

    @Override
    public void addToolStats(ToolRebuildContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        if (this.condition.matches(context, modifier)) {
            this.stat.update(builder, this.value);
        }
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public RecordLoadable<SetStatModule<?>> getLoader() {
        return LOADER;
    }

    public static <T> Builder<T> set(IToolStat<T> stat) {
        return new Builder<T>(stat);
    }

    public static class Builder<T>
    extends ModifierModuleCondition.Builder<Builder<T>> {
        private final IToolStat<T> stat;

        public SetStatModule<T> value(T value) {
            return new SetStatModule<T>(this.stat, value, this.condition);
        }

        private Builder(IToolStat<T> stat) {
            this.stat = stat;
        }
    }
}

